/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.Version;
import org.ironjacamar.codegenerator.code.PropsCodeGen;

public class AsCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            if (!def.isDefaultPackageInbound()) {
                out.write("@Activation(messageListeners = { " + def.getMlClass() + ".class })\n");
            } else {
                out.write("@Activation(messageListeners = { " + def.getRaPackage() + ".inflow." + def.getMlClass() + ".class })\n");
            }
        }
        out.write("public class " + this.getClassName(def) + " implements ActivationSpec");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        this.writeWithIndent(out, indent, "/** The resource adapter */\n");
        this.writeWithIndent(out, indent, "private ResourceAdapter ra;\n\n");
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        this.writeValidate(def, out, indent);
        this.writeResourceAdapter(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    void writeDefaultConstructor(Definition def, Writer out, int indent) throws IOException {
        if (!def.getVersion().equals(Version.V_15.getLocalName())) {
            super.writeDefaultConstructor(def, out, indent);
            return;
        }
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeConfigPropsDefaults(def, out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeConfigPropsDefaults(Definition def, Writer out, int indent) throws IOException {
        List<ConfigPropType> configPropTypes = def.getAsConfigProps();
        if (configPropTypes == null) {
            return;
        }
        block8: for (ConfigPropType configPropType : configPropTypes) {
            String name = configPropType.getName();
            String type = configPropType.getType();
            String value = configPropType.getValue();
            if (value == null || value.length() <= 0) continue;
            this.writeIndent(out, indent);
            this.writeIndent(out, indent);
            switch (type) {
                case "Character": {
                    out.write("this." + name + " = " + type + ".valueOf('" + value + "');\n");
                    continue block8;
                }
                case "String": {
                    out.write("this." + name + " = \"" + value + "\";\n");
                    continue block8;
                }
            }
            out.write("this." + name + " = " + type + ".valueOf(\"" + value + "\");\n");
        }
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".inflow;\n\n");
        this.importLogging(def, out);
        if (def.isUseAnnotation()) {
            out.write("import javax.resource.spi.Activation;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.ActivationSpec;\n");
        if (def.isUseAnnotation()) {
            this.importConfigProperty(def, out);
        }
        out.write("import javax.resource.spi.InvalidPropertyException;\n");
        out.write("import javax.resource.spi.ResourceAdapter;\n");
        if (def.isUseAnnotation()) {
            for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
                if (!this.getConfigProps(def).get(i).isRequired()) continue;
                out.write("import javax.validation.constraints.NotNull;\n");
                break;
            }
        }
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAsClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAsConfigProps();
    }

    private void writeValidate(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This method may be called by a deployment tool to validate the overall\n");
        this.writeWithIndent(out, indent, " * activation configuration information provided by the endpoint deployer.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @throws InvalidPropertyException indicates invalid configuration property settings.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void validate() throws InvalidPropertyException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "validate", new String[0]);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get the resource adapter\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return The handle\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getResourceAdapter", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set the resource adapter\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param ra The handle\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setResourceAdapter", "ra");
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

