/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class CciConnCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements Connection");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @param connSpec ConnectionSpec\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(ConnectionSpec connSpec)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeClose(def, out, indent);
        this.writeInteraction(def, out, indent);
        this.writeLocalTransaction(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeResultSetInfo(def, out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set ManagedConnection\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "void setManagedConnection(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import javax.resource.ResourceException;\n\n");
        out.write("import javax.resource.cci.Connection;\n");
        out.write("import javax.resource.cci.ConnectionMetaData;\n");
        out.write("import javax.resource.cci.ConnectionSpec;\n");
        out.write("import javax.resource.cci.Interaction;\n");
        out.write("import javax.resource.cci.LocalTransaction;\n");
        out.write("import javax.resource.cci.ResultSetInfo;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass();
    }

    private void writeClose(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Initiates close of the connection handle at the application level.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Exception thrown if close on a connection handle fails.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public void close() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeInteraction(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Creates an Interaction associated with this Connection. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Interaction instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to create an Interaction\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public Interaction createInteraction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLocalTransaction(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns an LocalTransaction instance that enables a component to \n");
        this.writeWithIndent(out, indent, " * demarcate resource manager local transactions on the Connection.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return LocalTransaction instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to return a LocalTransaction\n");
        this.writeWithIndent(out, indent, " * @throws javax.resource.NotSupportedException Demarcation of Resource manager \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public LocalTransaction getLocalTransaction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the information on the underlying EIS instance represented through an active connection.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return ConnectionMetaData instance representing information about the EIS instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to get information about the connected EIS instance. \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public ConnectionMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return new " + def.getMcfDefs().get(this.getNumOfMcf()).getConnMetaClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResultSetInfo(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the information on the ResultSet functionality supported by \n");
        this.writeWithIndent(out, indent, " * a connected EIS instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return ResultSetInfo instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to get ResultSet related information\n");
        this.writeWithIndent(out, indent, " * @throws javax.resource.NotSupportedException ResultSet functionality is not supported\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public ResultSetInfo getResultSetInfo() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

