/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class CciConnFactoryCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ConnectionFactory");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeWithIndent(out, indent, "private Reference reference;\n\n");
        this.writeDefaultConstructor(def, out, indent);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @param cxManager ConnectionManager\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(ConnectionManager cxManager)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeRecordFactory(def, out, indent);
        this.writeReference(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import javax.naming.NamingException;\n");
        out.write("import javax.naming.Reference;\n\n");
        out.write("import javax.resource.ResourceException;\n");
        out.write("import javax.resource.cci.Connection;\n");
        out.write("import javax.resource.cci.ConnectionFactory;\n");
        out.write("import javax.resource.cci.ConnectionSpec;\n");
        out.write("import javax.resource.cci.RecordFactory;\n");
        out.write("import javax.resource.cci.ResourceAdapterMetaData;\n");
        out.write("import javax.resource.spi.ConnectionManager;\n\n");
        if (def.getMcfDefs().size() != 1) {
            out.write("import " + def.getRaPackage() + ".*;\n\n");
        }
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getCciConnFactoryClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets a connection to an EIS instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Connection instance the EIS instance.\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to get a connection to\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public Connection getConnection() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "(new " + def.getMcfDefs().get(this.getNumOfMcf()).getConnSpecClass() + "());");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets a connection to an EIS instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param connSpec Connection parameters and security information specified as ConnectionSpec instance\n");
        this.writeWithIndent(out, indent, " * @return Connection instance the EIS instance.\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to get a connection to\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public Connection getConnection(ConnectionSpec connSpec) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "(connSpec);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets metadata for the Resource Adapter. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return ResourceAdapterMetaData instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to get metadata information \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public ResourceAdapterMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        if (def.isUseRa()) {
            out.write("return new " + def.getRaMetaClass() + "();");
        } else {
            out.write("return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeRecordFactory(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets a RecordFactory instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return RecordFactory instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Failed to create a RecordFactory\n");
        this.writeWithIndent(out, indent, " * @throws javax.resource.NotSupportedException Operation not supported\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public RecordFactory getRecordFactory() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get the Reference instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Reference instance\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set the Reference instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param reference A Reference instance\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

