/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class CfCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements " + def.getMcfDefs().get(this.getNumOfMcf()).getCfInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeWithIndent(out, indent, "/** The serial version UID */\n");
        this.writeWithIndent(out, indent, "private static final long serialVersionUID = 1L;\n\n");
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        this.writeWithIndent(out, indent, "/** Reference */\n");
        this.writeWithIndent(out, indent, "private Reference reference;\n\n");
        this.writeWithIndent(out, indent, "/** ManagedConnectionFactory */\n");
        this.writeWithIndent(out, indent, "private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf;\n\n");
        this.writeWithIndent(out, indent, "/** ConnectionManager */\n");
        this.writeWithIndent(out, indent, "private ConnectionManager connectionManager;\n\n");
        this.writeDefaultConstructor(def, out, indent);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @param mcf ManagedConnectionFactory\n");
        this.writeWithIndent(out, indent, " * @param cxManager ConnectionManager\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf, ConnectionManager cxManager)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.mcf = mcf;\n");
        this.writeWithIndent(out, indent + 1, "this.connectionManager = cxManager;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeReference(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        this.importLogging(def, out);
        out.write("import javax.naming.NamingException;\n");
        out.write("import javax.naming.Reference;\n\n");
        out.write("import javax.resource.ResourceException;\n");
        out.write("import javax.resource.spi.ConnectionManager;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getCfClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/** \n");
        this.writeWithIndent(out, indent, " * Get connection from factory\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " instance\n");
        this.writeWithIndent(out, indent, " * @exception ResourceException Thrown if a connection can't be obtained\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " getConnection() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getConnection", new String[0]);
        this.writeWithIndent(out, indent + 1, "return (" + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + ")connectionManager.allocateConnection(mcf, null);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get the Reference instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Reference instance\n");
        this.writeWithIndent(out, indent, " * @exception NamingException Thrown if a reference can't be obtained\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getReference", new String[0]);
        this.writeIndent(out, indent + 1);
        out.write("return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set the Reference instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param reference A Reference instance\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setReference", "reference");
        this.writeIndent(out, indent + 1);
        out.write("this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

