/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class CfInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public interface " + this.getClassName(def) + " extends Serializable, Referenceable");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeConnection(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import java.io.Serializable;\n\n");
        out.write("import javax.resource.Referenceable;\n");
        out.write("import javax.resource.ResourceException;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getCfInterfaceClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/** \n");
        this.writeWithIndent(out, indent, " * Get connection from factory\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " instance\n");
        this.writeWithIndent(out, indent, " * @exception ResourceException Thrown if a connection can't be obtained\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " getConnection() throws ResourceException;\n");
    }
}

