/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.MethodParam;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class ConnImplCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        this.writeWithIndent(out, indent, "/** ManagedConnection */\n");
        this.writeWithIndent(out, indent, "private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc;\n\n");
        this.writeWithIndent(out, indent, "/** ManagedConnectionFactory */\n");
        this.writeWithIndent(out, indent, "private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf;\n\n");
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @param mc " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass());
        this.writeEol(out);
        this.writeWithIndent(out, indent, " * @param mcf " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass());
        this.writeEol(out);
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc, " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.mc = mc;\n");
        this.writeWithIndent(out, indent + 1, "this.mcf = mcf;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeMethod(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        this.importLogging(def, out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass();
    }

    private void writeMethod(Definition def, Writer out, int indent) throws IOException {
        if (def.getMcfDefs().get(this.getNumOfMcf()).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(this.getNumOfMcf()).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(this.getNumOfMcf()).getMethods()) {
                    this.writeMethodSignature(out, indent, method);
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeIndent(out, indent + 1);
                    if (!method.getReturnType().equals("void")) {
                        out.write("return ");
                    }
                    out.write("mc." + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (int i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(");");
                    this.writeRightCurlyBracket(out, indent);
                    this.writeEol(out);
                }
            }
        } else {
            this.writeSimpleMethodSignature(out, indent, " * Call me", "public void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "if (mc != null)\n");
            this.writeWithIndent(out, indent + 2, "mc.callMe();");
            this.writeRightCurlyBracket(out, indent);
        }
        this.writeEol(out);
        this.writeSimpleMethodSignature(out, indent, " * Close", "public void close()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "if (mc != null)\n");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 2, "mc.closeHandle(this);\n");
        this.writeIndent(out, indent + 2);
        out.write("mc = null;");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set ManagedConnection\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "void setManagedConnection(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + " mc)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.mc = mc;");
        this.writeRightCurlyBracket(out, indent);
    }
}

