/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class ConnInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public interface " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(this.getNumOfMcf()).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(this.getNumOfMcf()).getMethods()) {
                    this.writeMethodSignature(out, indent, method);
                    out.write(";\n");
                }
            }
        } else {
            this.writeSimpleMethodSignature(out, indent, " * Call me", "public void callMe();");
        }
        this.writeEol(out);
        this.writeSimpleMethodSignature(out, indent, " * Close", "public void close();");
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass();
    }
}

