/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.MethodParam;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class MbeanImplCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public class " + this.getClassName(def) + " implements " + def.getMbeanInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        this.writeVars(def, out, indent);
        this.writeEol(out);
        this.writeMBeanLifecycle(def, out, indent);
        this.writeEol(out);
        this.writeMethods(def, out, indent);
        this.writeEol(out);
        this.writeGetConnection(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    void writeConstructor(Definition def, Writer out, int indent) throws IOException {
        this.writeSimpleMethodSignature(out, indent, " * Default constructor", "public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.mbeanServer = null;\n");
        this.writeWithIndent(out, indent + 1, "this.objectName = \"" + def.getDefaultValue() + ",class=HelloWorld\";\n");
        this.writeWithIndent(out, indent + 1, "this.registered = false;\n\n");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".mbean;\n\n");
        out.write("import javax.management.MBeanServer;\n");
        out.write("import javax.management.ObjectName;\n");
        out.write("import javax.naming.InitialContext;\n\n");
        out.write("import " + def.getRaPackage() + "." + def.getMcfDefs().get(0).getConnInterfaceClass() + ";\n");
        out.write("import " + def.getRaPackage() + "." + def.getMcfDefs().get(0).getCfInterfaceClass() + ";\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMbeanImplClass();
    }

    private void writeVars(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/** JNDI name */\n");
        this.writeWithIndent(out, indent, "private static final String JNDI_NAME = \"java:/eis/" + def.getDefaultValue() + "\";\n\n");
        this.writeWithIndent(out, indent, "/** MBeanServer instance */\n");
        this.writeWithIndent(out, indent, "private MBeanServer mbeanServer;\n\n");
        this.writeWithIndent(out, indent, "/** Object Name */\n");
        this.writeWithIndent(out, indent, "private String objectName;\n\n");
        this.writeWithIndent(out, indent, "/** The actual ObjectName instance */\n");
        this.writeWithIndent(out, indent, "private ObjectName on;\n\n");
        this.writeWithIndent(out, indent, "/** Registered */\n");
        this.writeWithIndent(out, indent, "private boolean registered;\n\n");
    }

    private void writeMethods(Definition def, Writer out, int indent) throws IOException {
        if (def.getMcfDefs().get(0).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(0).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(0).getMethods()) {
                    this.writeMethodSignature(out, indent, method);
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeIndent(out, indent + 1);
                    if (!method.getReturnType().equals("void")) {
                        out.write("return ");
                    }
                    out.write("getConnection()." + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (int i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(");\n");
                    this.writeRightCurlyBracket(out, indent);
                }
            }
        } else {
            this.writeSimpleMethodSignature(out, indent, " * Call me", "public void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "try");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeWithIndent(out, indent + 2, "getConnection().callMe();");
            this.writeRightCurlyBracket(out, indent + 1);
            this.writeWithIndent(out, indent + 1, "catch (Exception e)");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeRightCurlyBracket(out, indent + 1);
            this.writeRightCurlyBracket(out, indent);
        }
    }

    private void writeGetConnection(Definition def, Writer out, int indent) throws IOException {
        String connInterface = def.getMcfDefs().get(0).getConnInterfaceClass();
        String cfInterface = def.getMcfDefs().get(0).getCfInterfaceClass();
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * GetConnection\n");
        this.writeWithIndent(out, indent, " * @return " + connInterface);
        this.writeEol(out);
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "private " + connInterface + " getConnection() throws Exception");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "InitialContext context = new InitialContext();\n");
        this.writeIndent(out, indent + 1);
        out.write(cfInterface + " factory = (" + cfInterface + ")context.lookup(JNDI_NAME);\n");
        this.writeIndent(out, indent + 1);
        out.write(connInterface + " conn = factory.getConnection();\n");
        this.writeWithIndent(out, indent + 1, "if (conn == null)");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeIndent(out, indent + 2);
        out.write("throw new RuntimeException(\"No connection\");");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 1, "return conn;");
        this.writeRightCurlyBracket(out, indent);
    }

    private void writeMBeanLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set the MBean server\n");
        this.writeWithIndent(out, indent, " * @param v The value\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void setMBeanServer(MBeanServer v)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "mbeanServer = v;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Start\n");
        this.writeWithIndent(out, indent, " * @exception Throwable Thrown in case of an error\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void start() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "if (mbeanServer == null)\n");
        this.writeIndent(out, indent + 2);
        out.write("throw new IllegalArgumentException(\"MBeanServer is null\");\n");
        this.writeWithIndent(out, indent + 1, "on = new ObjectName(mbeanServer.getDefaultDomain() + objectName);\n");
        this.writeWithIndent(out, indent + 1, "mbeanServer.registerMBean(this, on);\n");
        this.writeWithIndent(out, indent + 1, "registered = true;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Stop\n");
        this.writeWithIndent(out, indent, " * @exception Throwable Thrown in case of an error\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void stop() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "if (registered)\n");
        this.writeIndent(out, indent + 2);
        out.write("mbeanServer.unregisterMBean(on); ");
        this.writeRightCurlyBracket(out, indent);
    }
}

