/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class MbeanInterfaceCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public interface " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        if (def.getMcfDefs().get(0).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(0).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(0).getMethods()) {
                    this.writeMethodSignature(out, indent, method);
                    out.write(";\n\n");
                }
            }
        } else {
            this.writeSimpleMethodSignature(out, indent, " * Call me", "public void callMe();");
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".mbean;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMbeanInterfaceClass();
    }
}

