/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.BasicType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class McCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public class " + this.getClassName(def) + " implements ManagedConnection");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        this.writeWithIndent(out, indent, "/** The logwriter */\n");
        this.writeWithIndent(out, indent, "private PrintWriter logwriter;\n\n");
        this.writeWithIndent(out, indent, "/** ManagedConnectionFactory */\n");
        this.writeWithIndent(out, indent, "private " + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf;\n\n");
        this.writeWithIndent(out, indent, "/** Listeners */\n");
        this.writeWithIndent(out, indent, "private List<ConnectionEventListener> listeners;\n\n");
        this.writeWithIndent(out, indent, "/** Connections */\n");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            this.writeWithIndent(out, indent, "private Set<" + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "> connections;\n\n");
        } else {
            this.writeWithIndent(out, indent, "private Set<" + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + "> connections;\n\n");
        }
        if (def.isSupportEis()) {
            this.writeWithIndent(out, indent, "/** Socket */\n");
            this.writeWithIndent(out, indent, "private Socket socket;\n\n");
        }
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @param mcf mcf\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(" + def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass() + " mcf)");
        if (def.isSupportEis()) {
            out.write(" throws ResourceException");
        }
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.mcf = mcf;\n");
        this.writeWithIndent(out, indent + 1, "this.logwriter = null;\n");
        this.writeWithIndent(out, indent + 1, "this.listeners = Collections.synchronizedList(new ArrayList<ConnectionEventListener>(1));\n");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            this.writeWithIndent(out, indent + 1, "this.connections = new HashSet<" + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + ">();");
        } else {
            this.writeWithIndent(out, indent + 1, "this.connections = new HashSet<" + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + ">();");
        }
        if (def.isSupportEis()) {
            this.writeEol(out);
            this.writeWithIndent(out, indent + 1, "this.socket = null; // TODO: Initialize me");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeLifecycle(def, out, indent);
        this.writeConnectionEventListener(def, out, indent);
        this.writeLogWriter(def, out, indent);
        this.writeTransaction(def, out, indent);
        this.writeMetaData(def, out, indent);
        this.writeMethod(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        if (def.isSupportEis()) {
            out.write("import java.io.IOException;\n");
        }
        out.write("import java.io.PrintWriter;\n");
        if (def.isSupportEis()) {
            out.write("import java.net.Socket;\n");
        }
        out.write("import java.util.ArrayList;\n");
        out.write("import java.util.Collections;\n");
        out.write("import java.util.HashSet;\n");
        out.write("import java.util.List;\n");
        out.write("import java.util.Set;\n");
        this.importLogging(def, out);
        out.write("import javax.resource.NotSupportedException;\n");
        out.write("import javax.resource.ResourceException;\n");
        out.write("import javax.resource.spi.ConnectionEvent;\n");
        out.write("import javax.resource.spi.ConnectionEventListener;\n");
        out.write("import javax.resource.spi.ConnectionRequestInfo;\n");
        out.write("import javax.resource.spi.LocalTransaction;\n");
        out.write("import javax.resource.spi.ManagedConnection;\n");
        out.write("import javax.resource.spi.ManagedConnectionMetaData;\n\n");
        out.write("import javax.security.auth.Subject;\n");
        out.write("import javax.transaction.xa.XAResource;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Creates a new connection handle for the underlying physical connection \n");
        this.writeWithIndent(out, indent, " * represented by the ManagedConnection instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param subject Security context as JAAS subject\n");
        this.writeWithIndent(out, indent, " * @param cxRequestInfo ConnectionRequestInfo instance\n");
        this.writeWithIndent(out, indent, " * @return generic Object instance representing the connection handle. \n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public Object getConnection(Subject subject,\n");
        this.writeWithIndent(out, indent + 1, "ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getConnection", new String[0]);
        this.writeIndent(out, indent + 1);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + " connection = new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + "();\n");
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + " connection = new " + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + "(this, mcf);\n");
        }
        this.writeWithIndent(out, indent + 1, "connections.add(connection);\n");
        this.writeWithIndent(out, indent + 1, "return connection;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Used by the container to change the association of an \n");
        this.writeWithIndent(out, indent, " * application-level connection handle with a ManagedConneciton instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param connection Application-level connection handle\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void associateConnection(Object connection) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "associateConnection", "connection\n");
        this.writeWithIndent(out, indent + 1, "if (connection == null)\n");
        this.writeWithIndent(out, indent + 2, "throw new ResourceException(\"Null connection handle\");\n\n");
        this.writeWithIndent(out, indent + 1, "if (!(connection instanceof ");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write("))\n");
        this.writeWithIndent(out, indent + 2, "throw new ResourceException(\"Wrong connection handle\");\n\n");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            this.writeWithIndent(out, indent + 1, def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            this.writeWithIndent(out, indent + 1, def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write(" handle = (");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write(")connection;\n");
        this.writeWithIndent(out, indent + 1, "handle.setManagedConnection(this);\n");
        this.writeWithIndent(out, indent + 1, "connections.add(handle);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Application server calls this method to force any cleanup on the ManagedConnection instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void cleanup() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "cleanup", new String[0]);
        this.writeWithIndent(out, indent + 1, "for (");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write(" connection : connections)");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 2, "connection.setManagedConnection(null);");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 1, "connections.clear();\n");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Destroys the physical connection to the underlying resource manager.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void destroy() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "destroy", new String[0]);
        if (def.isSupportEis()) {
            this.writeEol(out);
            this.writeWithIndent(out, indent + 1, "if (socket != null)");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeWithIndent(out, indent + 2, "try");
            this.writeLeftCurlyBracket(out, indent + 2);
            this.writeWithIndent(out, indent + 3, "socket.close();");
            this.writeRightCurlyBracket(out, indent + 2);
            this.writeWithIndent(out, indent + 2, "catch (IOException ioe)");
            this.writeLeftCurlyBracket(out, indent + 2);
            this.writeWithIndent(out, indent + 3, "// Ignore");
            this.writeRightCurlyBracket(out, indent + 2);
            this.writeRightCurlyBracket(out, indent + 1);
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeConnectionEventListener(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Adds a connection event listener to the ManagedConnection instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param listener A new ConnectionEventListener to be registered\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void addConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "addConnectionEventListener", "listener");
        this.writeWithIndent(out, indent + 1, "if (listener == null)\n");
        this.writeWithIndent(out, indent + 2, "throw new IllegalArgumentException(\"Listener is null\");\n");
        this.writeWithIndent(out, indent + 1, "listeners.add(listener);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Removes an already registered connection event listener from the ManagedConnection instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param listener already registered connection event listener to be removed\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void removeConnectionEventListener(ConnectionEventListener listener)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "removeConnectionEventListener", "listener");
        this.writeWithIndent(out, indent + 1, "if (listener == null)\n");
        this.writeWithIndent(out, indent + 2, "throw new IllegalArgumentException(\"Listener is null\");\n");
        this.writeWithIndent(out, indent + 1, "listeners.remove(listener);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Close handle\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param handle The handle\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "void closeHandle(");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + " handle)");
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + " handle)");
        }
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "connections.remove((");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass());
        } else {
            out.write(def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass());
        }
        out.write(")handle);\n");
        this.writeWithIndent(out, indent + 1, "ConnectionEvent event = new ConnectionEvent(this, ConnectionEvent.CONNECTION_CLOSED);\n");
        this.writeWithIndent(out, indent + 1, "event.setConnectionHandle(handle);\n");
        this.writeWithIndent(out, indent + 1, "for (ConnectionEventListener cel : listeners)");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 2, "cel.connectionClosed(event);");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeTransaction(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns an <code>javax.resource.spi.LocalTransaction</code> instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return LocalTransaction instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public LocalTransaction getLocalTransaction() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.getSupportTransaction().equals("NoTransaction")) {
            this.writeWithIndent(out, indent + 1, "throw new NotSupportedException(\"getLocalTransaction() not supported\");");
        } else {
            this.writeLogging(def, out, indent + 1, "trace", "getLocalTransaction", new String[0]);
            this.writeWithIndent(out, indent + 1, "return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns an <code>javax.transaction.xa.XAresource</code> instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return XAResource instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public XAResource getXAResource() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.getSupportTransaction().equals("NoTransaction")) {
            this.writeWithIndent(out, indent + 1, "throw new NotSupportedException(\"getXAResource() not supported\");");
        } else {
            this.writeLogging(def, out, indent + 1, "trace", "getXAResource", new String[0]);
            this.writeWithIndent(out, indent + 1, "return null;");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMetaData(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the metadata information for this connection's underlying EIS resource manager instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return ManagedConnectionMetaData instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public ManagedConnectionMetaData getMetaData() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getMetaData", new String[0]);
        this.writeWithIndent(out, indent + 1, "return new " + def.getMcfDefs().get(this.getNumOfMcf()).getMcMetaClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMethod(Definition def, Writer out, int indent) throws IOException {
        if (def.getMcfDefs().get(this.getNumOfMcf()).isDefineMethodInConnection()) {
            if (def.getMcfDefs().get(this.getNumOfMcf()).getMethods().size() > 0) {
                for (MethodForConnection method : def.getMcfDefs().get(this.getNumOfMcf()).getMethods()) {
                    this.writeMethodSignature(out, indent, method);
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeLogging(def, out, indent + 1, "trace", method.getMethodName(), new String[0]);
                    if (!method.getReturnType().equals("void")) {
                        this.writeEol(out);
                        if (BasicType.isPrimitiveType(method.getReturnType())) {
                            this.writeWithIndent(out, indent + 1, "return " + BasicType.defaultValue(method.getReturnType()) + ";");
                        } else {
                            this.writeWithIndent(out, indent + 1, "return null;");
                        }
                    }
                    this.writeRightCurlyBracket(out, indent);
                }
            }
        } else {
            this.writeSimpleMethodSignature(out, indent, " * Call me", "void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeLogging(def, out, indent + 1, "trace", "callMe", new String[0]);
            this.writeRightCurlyBracket(out, indent);
        }
    }
}

