/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class McMetaCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ManagedConnectionMetaData");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        this.writeDefaultConstructor(def, out, indent);
        this.writeEIS(def, out, indent);
        this.writeMaxConnection(def, out, indent);
        this.writeUsername(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        this.importLogging(def, out);
        out.write("import javax.resource.ResourceException;\n\n");
        out.write("import javax.resource.spi.ManagedConnectionMetaData;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcMetaClass();
    }

    private void writeEIS(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns Product name of the underlying EIS instance connected through the ManagedConnection.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Product name of the EIS instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getEISProductName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getEISProductName", new String[0]);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns Product version of the underlying EIS instance connected through the ManagedConnection.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Product version of the EIS instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getEISProductVersion() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getEISProductVersion", new String[0]);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMaxConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns maximum limit on number of active concurrent connections \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Maximum limit for number of active concurrent connections\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public int getMaxConnections() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getMaxConnections", new String[0]);
        this.writeWithIndent(out, indent + 1, "return 0; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeUsername(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns name of the user associated with the ManagedConnection instance\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Name of the user\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getUserName() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getUserName", new String[0]);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

