/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.PropsCodeGen;

public class McfCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        if (def.isUseAnnotation()) {
            if (!def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
                out.write("@ConnectionDefinition(connectionFactory = " + def.getMcfDefs().get(this.getNumOfMcf()).getCfInterfaceClass() + ".class,\n");
                this.writeWithIndent(out, indent, " connectionFactoryImpl = " + def.getMcfDefs().get(this.getNumOfMcf()).getCfClass() + ".class,\n");
                this.writeWithIndent(out, indent, " connection = " + def.getMcfDefs().get(this.getNumOfMcf()).getConnInterfaceClass() + ".class,\n");
                this.writeWithIndent(out, indent, " connectionImpl = " + def.getMcfDefs().get(this.getNumOfMcf()).getConnImplClass() + ".class)\n");
            } else {
                out.write("@ConnectionDefinition(connectionFactory = ConnectionFactory.class,\n");
                this.writeWithIndent(out, indent, " connectionFactoryImpl = " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnFactoryClass() + ".class,\n");
                this.writeWithIndent(out, indent, " connection = Connection.class,\n");
                this.writeWithIndent(out, indent, " connectionImpl = " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnClass() + ".class)\n");
            }
        }
        out.write("public class " + this.getClassName(def) + " implements ManagedConnectionFactory");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isImplRaAssociation()) {
            out.write(", ResourceAdapterAssociation");
        }
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/** The serial version UID */\n");
        this.writeWithIndent(out, indent, "private static final long serialVersionUID = 1L;\n\n");
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isImplRaAssociation()) {
            this.writeWithIndent(out, indent, "/** The resource adapter */\n");
            this.writeIndent(out, indent);
            if (def.isRaSerial()) {
                out.write("private ResourceAdapter ra;");
            } else {
                out.write("private transient ResourceAdapter ra;");
            }
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeWithIndent(out, indent, "/** The logwriter */\n");
        this.writeWithIndent(out, indent, "private PrintWriter logwriter;\n\n");
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        this.writeConnectionFactory(def, out, indent);
        this.writeManagedConnection(def, out, indent);
        this.writeLogWriter(def, out, indent);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isImplRaAssociation()) {
            this.writeResourceAdapter(def, out, indent);
        }
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import java.io.PrintWriter;\n");
        out.write("import java.util.Iterator;\n");
        out.write("import java.util.Set;\n\n");
        this.importLogging(def, out);
        out.write("import javax.resource.ResourceException;\n");
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write("import javax.resource.cci.Connection;\n");
            out.write("import javax.resource.cci.ConnectionFactory;\n");
        }
        if (def.isUseAnnotation()) {
            this.importConfigProperty(def, out);
            out.write("import javax.resource.spi.ConnectionDefinition;\n");
        }
        out.write("import javax.resource.spi.ConnectionManager;\n");
        out.write("import javax.resource.spi.ConnectionRequestInfo;\n");
        out.write("import javax.resource.spi.ManagedConnection;\n");
        out.write("import javax.resource.spi.ManagedConnectionFactory;\n");
        out.write("import javax.resource.spi.ResourceAdapter;\n");
        out.write("import javax.resource.spi.ResourceAdapterAssociation;\n\n");
        out.write("import javax.security.auth.Subject;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcfClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getMcfDefs().get(this.getNumOfMcf()).getMcfConfigProps();
    }

    private void writeConnectionFactory(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Creates a Connection Factory instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param cxManager ConnectionManager to be associated with created EIS connection factory instance\n");
        this.writeWithIndent(out, indent, " * @return EIS-specific Connection Factory instance or javax.resource.cci.ConnectionFactory instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Generic exception\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "createConnectionFactory", "cxManager");
        this.writeIndent(out, indent + 1);
        if (def.getMcfDefs().get(this.getNumOfMcf()).isUseCciConnection()) {
            out.write("return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCciConnFactoryClass() + "(cxManager);");
        } else {
            out.write("return new " + def.getMcfDefs().get(this.getNumOfMcf()).getCfClass() + "(this, cxManager);");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Creates a Connection Factory instance. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return EIS-specific Connection Factory instance or javax.resource.cci.ConnectionFactory instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Generic exception\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public Object createConnectionFactory() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "throw new ResourceException(\"This resource adapter doesn't support non-managed environments\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeManagedConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Creates a new physical connection to the underlying EIS resource manager.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param subject Caller's security information\n");
        this.writeWithIndent(out, indent, " * @param cxRequestInfo Additional resource adapter specific connection request information\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception\n");
        this.writeWithIndent(out, indent, " * @return ManagedConnection instance \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public ManagedConnection createManagedConnection(Subject subject,\n");
        this.writeIndent(out, indent + 2);
        out.write("ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "createManagedConnection", "subject", "cxRequestInfo");
        this.writeWithIndent(out, indent + 1, "return new " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + "(this);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns a matched connection from the candidate set of connections. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param connectionSet Candidate connection set\n");
        this.writeWithIndent(out, indent, " * @param subject Caller's security information\n");
        this.writeWithIndent(out, indent, " * @param cxRequestInfo Additional resource adapter specific connection request information\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception\n");
        this.writeWithIndent(out, indent, " * @return ManagedConnection if resource adapter finds an acceptable match otherwise null \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public ManagedConnection matchManagedConnections(Set connectionSet,\n");
        this.writeIndent(out, indent + 2);
        out.write("Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "matchManagedConnections", "connectionSet", "subject", "cxRequestInfo");
        this.writeWithIndent(out, indent + 1, "ManagedConnection result = null;\n");
        this.writeWithIndent(out, indent + 1, "Iterator it = connectionSet.iterator();\n");
        this.writeWithIndent(out, indent + 1, "while (result == null && it.hasNext())");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeIndent(out, indent + 2);
        out.write("ManagedConnection mc = (ManagedConnection)it.next();\n");
        this.writeIndent(out, indent + 2);
        out.write("if (mc instanceof " + def.getMcfDefs().get(this.getNumOfMcf()).getMcClass() + ")");
        this.writeLeftCurlyBracket(out, indent + 2);
        this.writeIndent(out, indent + 3);
        out.write("result = mc;");
        this.writeRightCurlyBracket(out, indent + 2);
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeWithIndent(out, indent + 1, "return result;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get the resource adapter\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return The handle\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getResourceAdapter", new String[0]);
        this.writeWithIndent(out, indent + 1, "return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Set the resource adapter\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param ra The handle\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setResourceAdapter", "ra");
        this.writeWithIndent(out, indent + 1, "this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

