/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public abstract class PropsCodeGen
extends AbstractCodeGen {
    void writeConfigPropsDeclare(Definition def, Writer out, int indent) throws IOException {
        if (this.getConfigProps(def) == null) {
            return;
        }
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeWithIndent(out, indent, "/** " + this.getConfigProps(def).get(i).getName() + " */\n");
            if (def.isUseAnnotation()) {
                this.writeIndent(out, indent);
                out.write("@ConfigProperty(defaultValue = \"" + this.getConfigProps(def).get(i).getValue() + "\")");
                if (this.getConfigProps(def).get(i).isRequired()) {
                    out.write(" @NotNull");
                }
                this.writeEol(out);
            }
            this.writeWithIndent(out, indent, "private " + this.getConfigProps(def).get(i).getType() + " " + this.getConfigProps(def).get(i).getName() + ";\n\n");
        }
    }

    void writeConfigProps(Definition def, Writer out, int indent) throws IOException {
        if (this.getConfigProps(def) == null) {
            return;
        }
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            String name = this.getConfigProps(def).get(i).getName();
            String upcaseName = this.upcaseFirst(name);
            this.writeWithIndent(out, indent, "/** \n");
            this.writeWithIndent(out, indent, " * Set " + name);
            this.writeEol(out);
            this.writeWithIndent(out, indent, " * @param " + name + " The value\n");
            this.writeWithIndent(out, indent, " */\n");
            this.writeWithIndent(out, indent, "public void set" + upcaseName + "(" + this.getConfigProps(def).get(i).getType() + " " + name + ")");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "this." + name + " = " + name + ";");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
            this.writeWithIndent(out, indent, "/** \n");
            this.writeWithIndent(out, indent, " * Get " + name);
            this.writeEol(out);
            this.writeWithIndent(out, indent, " * @return The value\n");
            this.writeWithIndent(out, indent, " */\n");
            this.writeWithIndent(out, indent, "public " + this.getConfigProps(def).get(i).getType() + " get" + upcaseName + "()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "return " + name + ";");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
        }
    }

    @Override
    void writeHashCode(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** \n");
        this.writeIndent(out, indent);
        out.write(" * Returns a hash code value for the object.\n");
        this.writeIndent(out, indent);
        out.write(" * @return A hash code value for this object.\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("@Override\n");
        this.writeIndent(out, indent);
        out.write("public int hashCode()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "int result = 17;\n");
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeWithIndent(out, indent + 1, "if (" + this.getConfigProps(def).get(i).getName() + " != null)\n");
            this.writeWithIndent(out, indent + 2, "result += 31 * result + 7 * " + this.getConfigProps(def).get(i).getName() + ".hashCode();\n");
            this.writeIndent(out, indent + 1);
            out.write("else\n");
            this.writeWithIndent(out, indent + 2, "result += 31 * result + 7;\n");
        }
        this.writeWithIndent(out, indent + 1, "return result;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    void writeEquals(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** \n");
        this.writeIndent(out, indent);
        out.write(" * Indicates whether some other object is equal to this one.\n");
        this.writeIndent(out, indent);
        out.write(" * @param other The reference object with which to compare.\n");
        this.writeIndent(out, indent);
        out.write(" * @return true if this object is the same as the obj argument, false otherwise.\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("@Override\n");
        this.writeIndent(out, indent);
        out.write("public boolean equals(Object other)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "if (other == null)\n");
        this.writeWithIndent(out, indent + 2, "return false;\n");
        this.writeWithIndent(out, indent + 1, "if (other == this)\n");
        this.writeWithIndent(out, indent + 2, "return true;\n");
        this.writeWithIndent(out, indent + 1, "if (!(other instanceof " + this.getClassName(def) + "))\n");
        this.writeWithIndent(out, indent + 2, "return false;\n");
        this.writeWithIndent(out, indent + 1, "boolean result = true;\n");
        if (this.getConfigProps(def).size() > 0) {
            this.writeIndent(out, indent + 1);
            out.write(this.getClassName(def) + " obj = (" + this.getClassName(def) + ")other;\n");
        }
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            this.writeWithIndent(out, indent + 1, "if (result)");
            this.writeLeftCurlyBracket(out, indent + 1);
            this.writeWithIndent(out, indent + 2, "if (" + this.getConfigProps(def).get(i).getName() + " == null)\n");
            this.writeWithIndent(out, indent + 3, "result = obj.get" + this.upcaseFirst(this.getConfigProps(def).get(i).getName()) + "() == null;\n");
            this.writeWithIndent(out, indent + 2, "else\n");
            this.writeWithIndent(out, indent + 3, "result = " + this.getConfigProps(def).get(i).getName() + ".equals(obj.get" + this.upcaseFirst(this.getConfigProps(def).get(i).getName()) + "());");
            this.writeRightCurlyBracket(out, indent + 1);
        }
        this.writeWithIndent(out, indent + 1, "return result;");
        this.writeRightCurlyBracket(out, indent);
    }

    public abstract List<ConfigPropType> getConfigProps(Definition var1);

    protected void importConfigProperty(Definition def, Writer out) throws IOException {
        if (this.getConfigProps(def).size() > 0) {
            out.write("import javax.resource.spi.ConfigProperty;\n");
        }
    }
}

