/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.PropsCodeGen;

public class RaCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            out.write("@Connector");
            if (def.isSupportOutbound()) {
                int i;
                out.write("(\n");
                if (def.getAuthenMechanisms() != null && def.getAuthenMechanisms().size() > 0) {
                    this.writeWithIndent(out, 1, "authMechanisms = {\n");
                    for (i = 0; i < def.getAuthenMechanisms().size(); ++i) {
                        this.writeWithIndent(out, 2, "@AuthenticationMechanism(");
                        out.write("authMechanism = \"" + def.getAuthenMechanisms().get(i).getAuthMechanism());
                        out.write("\", credentialInterface = CredentialInterface." + def.getAuthenMechanisms().get(i).getCredentialInterface());
                        if (i + 1 < def.getAuthenMechanisms().size()) {
                            out.write("),");
                        } else {
                            out.write(")},");
                        }
                        this.writeEol(out);
                    }
                }
                this.writeIndent(out, 1);
                out.write("reauthenticationSupport = " + def.isSupportReauthen() + ",\n");
                if (def.getSecurityPermissions() != null && def.getSecurityPermissions().size() > 0) {
                    this.writeWithIndent(out, 1, "securityPermissions = {\n");
                    for (i = 0; i < def.getSecurityPermissions().size(); ++i) {
                        this.writeWithIndent(out, 2, "@SecurityPermission(");
                        out.write("permissionSpec = \"" + def.getSecurityPermissions().get(i).getPermissionSpec() + "\")");
                        if (i + 1 < def.getSecurityPermissions().size()) {
                            out.write(",");
                        } else {
                            out.write("},");
                        }
                        this.writeEol(out);
                    }
                }
                this.writeIndent(out, 1);
                out.write("transactionSupport = TransactionSupport.TransactionSupportLevel." + def.getSupportTransaction() + ")");
            }
            this.writeEol(out);
        }
        out.write("public class " + this.getClassName(def) + " implements ResourceAdapter");
        if (def.isRaSerial()) {
            out.write(", java.io.Serializable");
        }
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        if (def.isRaSerial()) {
            this.writeWithIndent(out, indent, "/** The serial version UID */\n");
            this.writeWithIndent(out, indent, "private static final long serialVersionUID = 1L;\n\n");
        }
        this.writeWithIndent(out, indent, "/** The logger */\n");
        this.writeWithIndent(out, indent, "private static Logger log = Logger.getLogger(" + this.getSelfClassName(def) + ");\n\n");
        if (def.isSupportInbound()) {
            this.writeWithIndent(out, indent, "/** The activations by activation spec */\n");
            this.writeWithIndent(out, indent, "private ");
            if (def.getVersion().equals("1.6") || def.getVersion().equals("1.7")) {
                out.write("ConcurrentHash");
            }
            out.write("Map<" + def.getAsClass() + ", " + def.getActivationClass() + "> activations;\n\n");
        }
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeSimpleMethodSignature(out, indent, " * Default constructor", "public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            if (def.getVersion().equals("1.6") || def.getVersion().equals("1.7")) {
                this.writeWithIndent(out, indent + 1, "this.activations = new ConcurrentHashMap<" + def.getAsClass() + ", " + def.getActivationClass() + ">();\n");
            } else {
                this.writeWithIndent(out, indent + 1, "this.activations = Collections.synchronizedMap(new HashMap<" + def.getAsClass() + ", " + def.getActivationClass() + ">());\n");
            }
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConfigProps(def, out, indent);
        this.writeEndpointLifecycle(def, out, indent);
        this.writeLifecycle(def, out, indent);
        this.writeXAResource(def, out, indent);
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        if (def.isSupportInbound()) {
            out.write("import " + def.getRaPackage() + ".inflow." + def.getActivationClass() + ";\n");
            out.write("import " + def.getRaPackage() + ".inflow." + def.getAsClass() + ";\n\n");
            if (def.getVersion().equals("1.5")) {
                out.write("import java.util.Collections;\n");
                out.write("import java.util.HashMap;\n");
                out.write("import java.util.Map;\n");
                this.writeEol(out);
            } else if (def.getVersion().equals("1.6") || def.getVersion().equals("1.7")) {
                out.write("import java.util.concurrent.ConcurrentHashMap;\n");
                this.writeEol(out);
            }
        }
        this.importLogging(def, out);
        out.write("import javax.resource.ResourceException;\n");
        out.write("import javax.resource.spi.ActivationSpec;\n");
        if (def.isUseAnnotation() && def.getAuthenMechanisms() != null && def.getAuthenMechanisms().size() > 0) {
            out.write("import javax.resource.spi.AuthenticationMechanism;\n");
            out.write("import javax.resource.spi.AuthenticationMechanism.CredentialInterface;\n");
        }
        out.write("import javax.resource.spi.BootstrapContext;\n");
        if (def.isUseAnnotation()) {
            this.importConfigProperty(def, out);
            out.write("import javax.resource.spi.Connector;\n");
        }
        out.write("import javax.resource.spi.ResourceAdapter;\n");
        out.write("import javax.resource.spi.ResourceAdapterInternalException;\n");
        if (def.isUseAnnotation() && def.getSecurityPermissions() != null && def.getSecurityPermissions().size() > 0) {
            out.write("import javax.resource.spi.SecurityPermission;\n");
        }
        if (def.isUseAnnotation() && def.isSupportOutbound()) {
            out.write("import javax.resource.spi.TransactionSupport;\n");
        }
        out.write("import javax.resource.spi.endpoint.MessageEndpointFactory;\n\n");
        out.write("import javax.transaction.xa.XAResource;\n\n");
    }

    private void writeXAResource(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This method is called by the application server during crash recovery.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param specs An array of ActivationSpec JavaBeans \n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception \n");
        this.writeWithIndent(out, indent, " * @return An array of XAResource objects\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public XAResource[] getXAResources(ActivationSpec[] specs)\n");
        this.writeWithIndent(out, indent + 1, "throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getXAResources", "specs.toString()");
        this.writeWithIndent(out, indent + 1, "return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This is called when a resource adapter instance is bootstrapped.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param ctx A bootstrap context containing references \n");
        this.writeWithIndent(out, indent, " * @throws ResourceAdapterInternalException indicates bootstrap failure.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void start(BootstrapContext ctx)\n");
        this.writeWithIndent(out, indent + 1, "throws ResourceAdapterInternalException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "start", "ctx");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This is called when a resource adapter instance is undeployed or\n");
        this.writeWithIndent(out, indent, " * during application server shutdown. \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void stop()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "stop", new String[0]);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeEndpointLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This is called during the activation of a message endpoint.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param endpointFactory A message endpoint factory instance.\n");
        this.writeWithIndent(out, indent, " * @param spec An activation spec JavaBean instance.\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void endpointActivation(MessageEndpointFactory endpointFactory,\n");
        this.writeWithIndent(out, indent + 1, "ActivationSpec spec) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent + 1);
            out.write(def.getActivationClass() + " activation = new " + def.getActivationClass() + "(this, endpointFactory, (" + def.getAsClass() + ")spec);\n");
            this.writeWithIndent(out, indent + 1, "activations.put((" + def.getAsClass() + ")spec, activation);\n");
            this.writeWithIndent(out, indent + 1, "activation.start();\n\n");
        }
        this.writeLogging(def, out, indent + 1, "trace", "endpointActivation", "endpointFactory", "spec");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * This is called when a message endpoint is deactivated. \n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param endpointFactory A message endpoint factory instance.\n");
        this.writeWithIndent(out, indent, " * @param spec An activation spec JavaBean instance.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void endpointDeactivation(MessageEndpointFactory endpointFactory,\n");
        this.writeWithIndent(out, indent + 1, "ActivationSpec spec)");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isSupportInbound()) {
            this.writeIndent(out, indent + 1);
            out.write(def.getActivationClass() + " activation = activations.remove(spec);\n");
            this.writeWithIndent(out, indent + 1, "if (activation != null)\n");
            this.writeWithIndent(out, indent + 2, "activation.stop();\n\n");
        }
        this.writeLogging(def, out, indent + 1, "trace", "endpointDeactivation", "endpointFactory");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getRaClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getRaConfigProps();
    }
}

