/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class RaMetaCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ResourceAdapterMetaData");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeInfo(def, out, indent);
        this.writeSupport(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import javax.resource.cci.ResourceAdapterMetaData;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getRaMetaClass();
    }

    private void writeInfo(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the version of the resource adapter.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return String representing version of the resource adapter\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getAdapterVersion()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the name of the vendor that has provided the resource adapter.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return String representing name of the vendor \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getAdapterVendorName()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets a tool displayable name of the resource adapter.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return String representing the name of the resource adapter\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getAdapterName()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets a tool displayable short desription of the resource adapter.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return String describing the resource adapter\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getAdapterShortDescription()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns a string representation of the version\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return String representing the supported version of the connector architecture\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String getSpecVersion()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeSupport(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns an array of fully-qualified names of InteractionSpec\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Array of fully-qualified class names of InteractionSpec classes\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public String[] getInteractionSpecsSupported()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return null; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns true if the implementation class for the Interaction\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return boolean Depending on method support\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public boolean supportsExecuteWithInputAndOutputRecord()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return false; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns true if the implementation class for the Interaction\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return boolean Depending on method support\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public boolean supportsExecuteWithInputRecordOnly()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return false; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Returns true if the resource adapter implements the LocalTransaction\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return true If resource adapter supports resource manager local transaction demarcation \n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public boolean supportsLocalTransactionDemarcation()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return false; //TODO");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

