/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.BasicType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.McfDef;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.MethodParam;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class TestCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("@RunWith(IronJacamar.class)\n");
        out.write("@SuppressWarnings(\"rawtypes\")\n");
        out.write("public class " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        this.writeWithIndent(out, indent, "private static String deploymentName = \"" + this.getClassName(def) + "\";\n\n");
        this.writeResource(def, out, indent);
        this.writeDeployment(def, out, indent);
        this.writeActivation(def, out, indent);
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            if (def.getMcfDefs().get(num).isDefineMethodInConnection()) {
                this.writeTestMethod(def, out, indent, num + 1);
                continue;
            }
            this.writeTestBasic(def, out, indent, num + 1);
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        out.write("import org.ironjacamar.embedded.Deployment;\n");
        out.write("import org.ironjacamar.embedded.dsl.resourceadapters20.api.ConnectionDefinitionsType;\n");
        out.write("import org.ironjacamar.embedded.dsl.resourceadapters20.api.ResourceAdapterType;\n");
        out.write("import org.ironjacamar.embedded.dsl.resourceadapters20.api.ResourceAdaptersDescriptor;\n");
        out.write("import org.ironjacamar.embedded.junit4.IronJacamar;\n");
        this.writeEol(out);
        out.write("import javax.annotation.Resource;\n");
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.ShrinkWrap;\n");
        out.write("import org.jboss.shrinkwrap.api.asset.StringAsset;\n");
        out.write("import org.jboss.shrinkwrap.api.spec.JavaArchive;\n");
        out.write("import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;\n");
        out.write("import org.jboss.shrinkwrap.descriptor.api.Descriptors;\n");
        this.writeEol(out);
        out.write("import org.junit.Test;\n");
        out.write("import org.junit.runner.RunWith;\n");
        this.writeEol(out);
        out.write("import static org.junit.Assert.assertNotNull;\n");
    }

    @Override
    public String getClassName(Definition def) {
        return "ConnectorTestCase";
    }

    private void writeDeployment(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Define the deployment\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return The deployment archive\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Deployment(order = 1)\n");
        this.writeWithIndent(out, indent, "public static ResourceAdapterArchive createDeployment()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "org.jboss.shrinkwrap.descriptor.api.connector" + def.getVersionNoDot() + ".ConnectorDescriptor raXml = Descriptors\n");
        this.writeWithIndent(out, indent + 2, ".create(org.jboss.shrinkwrap.descriptor.api.connector" + def.getVersionNoDot() + " .ConnectorDescriptor.class, \"ra.xml\").version(\"" + def.getVersion() + "\");\n");
        this.writeWithIndent(out, indent + 1, "org.jboss.shrinkwrap.descriptor.api.connector" + def.getVersionNoDot() + ".ResourceadapterType rt = raXml.getOrCreateResourceadapter()" + (def.isUseRa() ? "" : ";") + "\n");
        if (def.isUseRa()) {
            this.writeWithIndent(out, indent + 2, ".resourceadapterClass(" + def.getRaClass() + ".class.getName());\n");
        }
        this.writeWithIndent(out, indent + 1, "org.jboss.shrinkwrap.descriptor.api.connector" + def.getVersionNoDot() + ".OutboundResourceadapterType ort = rt\n");
        this.writeWithIndent(out, indent + 2, ".getOrCreateOutboundResourceadapter().transactionSupport(\"" + def.getSupportTransaction() + "\").reauthenticationSupport(false);\n");
        for (McfDef mcfDef : def.getMcfDefs()) {
            this.writeWithIndent(out, indent + 1, "ort.createConnectionDefinition()\n");
            this.writeWithIndent(out, indent + 2, ".managedconnectionfactoryClass(" + mcfDef.getMcfClass() + ".class.getName())\n");
            this.writeWithIndent(out, indent + 2, ".connectionfactoryInterface(" + mcfDef.getCfInterfaceClass() + ".class.getName())\n");
            if (mcfDef.isUseCciConnection()) {
                this.writeWithIndent(out, indent + 2, ".connectionfactoryImplClass(" + mcfDef.getCciConnFactoryClass() + ".class.getName())\n");
            } else {
                this.writeWithIndent(out, indent + 2, ".connectionfactoryImplClass(" + mcfDef.getCfClass() + ".class.getName())\n");
            }
            this.writeWithIndent(out, indent + 2, ".connectionInterface(" + mcfDef.getConnInterfaceClass() + ".class.getName())\n");
            if (mcfDef.isUseCciConnection()) {
                this.writeWithIndent(out, indent + 2, ".connectionImplClass(" + mcfDef.getCciConnClass() + ".class.getName());\n");
                continue;
            }
            this.writeWithIndent(out, indent + 2, ".connectionImplClass(" + mcfDef.getConnImplClass() + ".class.getName());\n");
        }
        this.writeWithIndent(out, indent + 1, "ResourceAdapterArchive raa = ShrinkWrap.create(ResourceAdapterArchive.class, deploymentName + \".rar\");\n");
        this.writeWithIndent(out, indent + 1, "JavaArchive ja = ShrinkWrap.create(JavaArchive.class, deploymentName + \".rar\");\n");
        if (def.getMcfDefs().size() > 0) {
            this.writeWithIndent(out, indent + 1, "ja.addPackages(true, " + def.getMcfDefs().get(0).getMcfClass() + ".class.getPackage());\n");
        } else {
            this.writeWithIndent(out, indent + 1, "ja.addPackages(true, " + def.getRaClass() + ".class.getPackage());\n");
        }
        this.writeWithIndent(out, indent + 1, "raa.addAsLibrary(ja);\n");
        this.writeWithIndent(out, indent + 1, "raa.addAsManifestResource(new StringAsset(raXml.exportAsString()), \"ra.xml\");\n");
        this.writeWithIndent(out, indent + 1, "return raa;\n");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeActivation(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * The activation\n");
        this.writeWithIndent(out, indent, " * @throws Throwable In case of an error\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Deployment(order = 2)\n");
        this.writeWithIndent(out, indent, "private ResourceAdaptersDescriptor createActivation() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, ++indent, "ResourceAdaptersDescriptor dashRaXml = Descriptors.create(ResourceAdaptersDescriptor.class, deploymentName + \"-ra.xml\");\n");
        this.writeWithIndent(out, indent, "ResourceAdapterType dashRaXmlRt = dashRaXml.createResourceAdapter().archive(deploymentName + \".rar\");\n");
        this.writeWithIndent(out, indent, "String tsl = \"" + def.getSupportTransaction() + "\";\n");
        this.writeWithIndent(out, indent, "dashRaXmlRt.transactionSupport(tsl);\n");
        this.writeWithIndent(out, indent, "ConnectionDefinitionsType dashRaXmlCdst = dashRaXmlRt.getOrCreateConnectionDefinitions();\n");
        int count = 0;
        for (McfDef mcfDef : def.getMcfDefs()) {
            this.writeWithIndent(out, indent, "org.ironjacamar.embedded.dsl.resourceadapters20.api.ConnectionDefinitionType dashRaXmlCdt" + ++count + "= dashRaXmlCdst\n");
            if (mcfDef.isUseCciConnection()) {
                this.writeWithIndent(out, indent + 1, ".createConnectionDefinition().className(" + mcfDef.getCciConnFactoryClass() + ".class.getName())\n");
                this.writeWithIndent(out, indent + 1, ".jndiName(\"java:/eis/" + mcfDef.getCciConnFactoryClass() + "\").id(\"" + mcfDef.getCciConnFactoryClass() + "\");\n");
            } else {
                this.writeWithIndent(out, indent + 1, ".createConnectionDefinition().className(" + mcfDef.getCfInterfaceClass() + ".class.getName())\n");
                this.writeWithIndent(out, indent + 1, ".jndiName(\"java:/eis/" + mcfDef.getCfInterfaceClass() + "\").id(\"" + mcfDef.getCfInterfaceClass() + "\");\n");
            }
            this.writeWithIndent(out, indent, "if (tsl == null ||\n");
            this.writeWithIndent(out, indent + 1, "tsl.equals(\"NoTransaction\") ||\n");
            this.writeWithIndent(out, indent + 1, "tsl.equals(\"LocalTransaction\"))");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "dashRaXmlCdt" + count + ".getOrCreatePool().minPoolSize(0).initialPoolSize(0).maxPoolSize(10);\n");
            this.writeRightCurlyBracket(out, indent);
            this.writeWithIndent(out, indent, "else");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "dashRaXmlCdt" + count + ".getOrCreateXaPool().minPoolSize(0).initialPoolSize(0).maxPoolSize(10);\n");
            this.writeRightCurlyBracket(out, indent);
        }
        this.writeWithIndent(out, indent, "return dashRaXml;\n");
        this.writeRightCurlyBracket(out, indent - 1);
        this.writeEol(out);
    }

    private void writeResource(Definition def, Writer out, int indent) throws IOException {
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            this.writeWithIndent(out, indent, "/** Resource */\n");
            if (def.getMcfDefs().get(num).isUseCciConnection()) {
                this.writeWithIndent(out, indent, "@Resource(mappedName = \"java:/eis/" + def.getMcfDefs().get(num).getCciConnFactoryClass() + "\")\n");
            } else {
                this.writeWithIndent(out, indent, "@Resource(mappedName = \"java:/eis/" + def.getMcfDefs().get(num).getCfInterfaceClass() + "\")\n");
            }
            if (def.getMcfDefs().get(num).isUseCciConnection()) {
                this.writeWithIndent(out, indent, "private javax.resource.cci.ConnectionFactory");
            } else {
                this.writeWithIndent(out, indent, "private " + def.getMcfDefs().get(num).getCfInterfaceClass());
            }
            out.write(" connectionFactory" + (num + 1) + ";\n\n");
        }
    }

    private void writeTestBasic(Definition def, Writer out, int indent, int num) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Test getConnection\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @exception Throwable Thrown if case of an error\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Test\n");
        this.writeWithIndent(out, indent, "public void testGetConnection" + num + "() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "assertNotNull(connectionFactory" + num + ");\n");
        this.writeIndent(out, indent + 1);
        if (def.getMcfDefs().get(num - 1).isUseCciConnection()) {
            out.write("javax.resource.cci.Connection");
        } else {
            out.write(def.getMcfDefs().get(num - 1).getConnInterfaceClass());
        }
        out.write(" connection" + num + " = connectionFactory" + num + ".getConnection();\n");
        this.writeWithIndent(out, indent + 1, "assertNotNull(connection" + num + ");\n");
        this.writeWithIndent(out, indent + 1, "connection" + num + ".close();");
        this.writeRightCurlyBracket(out, indent);
    }

    private void writeTestMethod(Definition def, Writer out, int indent, int num) throws IOException {
        for (MethodForConnection method : def.getMcfDefs().get(num - 1).getMethods()) {
            MethodParam param;
            int i;
            this.writeWithIndent(out, indent, "/**\n");
            this.writeWithIndent(out, indent, " * Test " + method.getMethodName() + "\n");
            this.writeWithIndent(out, indent, " *\n");
            this.writeWithIndent(out, indent, " * @exception Throwable Thrown if case of an error\n");
            this.writeWithIndent(out, indent, " */\n");
            this.writeWithIndent(out, indent, "@Test\n");
            this.writeWithIndent(out, indent, "public void test" + this.upcaseFirst(method.getMethodName()));
            int paramSize = method.getParams().size();
            if (paramSize == 0) {
                out.write("NoArg");
            } else {
                for (i = 0; i < paramSize; ++i) {
                    param = method.getParams().get(i);
                    out.write(this.upcaseFirst(param.getName()));
                    String type = param.getType();
                    if (type.indexOf(".") >= 0) {
                        type = type.substring(type.lastIndexOf(".") + 1);
                    }
                    out.write(type);
                }
            }
            out.write("() throws Throwable");
            this.writeLeftCurlyBracket(out, indent);
            this.writeWithIndent(out, indent + 1, "assertNotNull(connectionFactory" + num + ");\n");
            this.writeIndent(out, indent + 1);
            if (def.getMcfDefs().get(num - 1).isUseCciConnection()) {
                out.write("javax.resource.cci.Connection");
            } else {
                out.write(def.getMcfDefs().get(num - 1).getConnInterfaceClass());
            }
            out.write(" connection" + num + " = connectionFactory" + num + ".getConnection();\n");
            this.writeWithIndent(out, indent + 1, "assertNotNull(connection" + num + ");\n");
            this.writeIndent(out, indent + 1);
            if (!method.getReturnType().equals("void")) {
                out.write(method.getReturnType() + " result = ");
            }
            out.write("connection" + num + "." + method.getMethodName() + "(");
            for (i = 0; i < paramSize; ++i) {
                param = method.getParams().get(i);
                out.write(BasicType.defaultValue(param.getType()));
                if (i + 1 >= paramSize) continue;
                out.write(", ");
            }
            out.write(");\n");
            this.writeWithIndent(out, indent + 1, "connection" + num + ".close();");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
        }
    }
}

