/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.xml;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.SimpleTemplate;
import org.ironjacamar.codegenerator.Utils;
import org.ironjacamar.codegenerator.xml.AbstractXmlGen;

public class BuildXmlGen
extends AbstractXmlGen {
    @Override
    public void writeXmlBody(Definition def, Writer out) throws IOException {
        URL buildFile = BuildXmlGen.class.getResource("/build.xml.template");
        out.write("<!--");
        this.writeEol(out);
        this.writeHeader(def, out);
        out.write("-->");
        this.writeEol(out);
        this.writeEol(out);
        String buildString = Utils.readFileIntoString(buildFile);
        String defName = "jca-test";
        if (def.getRaPackage() != null && !def.getRaPackage().equals("")) {
            defName = def.getRaPackage().indexOf(46) >= 0 ? def.getRaPackage().substring(def.getRaPackage().lastIndexOf(46) + 1) : def.getRaPackage();
        }
        StringBuilder strStartTask = new StringBuilder();
        if (def.isSupportEis()) {
            strStartTask.append("    <start host=\"localhost\" port=\"1400\"\n");
            strStartTask.append("      handler=\"" + def.getRaPackage() + "." + def.getDefaultValue() + "Handler\">\n");
            strStartTask.append("      <classpath>\n");
            strStartTask.append("        <pathelement location=\"${build.dir}/test\"/>\n");
            strStartTask.append("      </classpath>\n");
            strStartTask.append("    </start>\n");
        }
        StringBuilder strStopTask = new StringBuilder();
        if (def.isSupportEis()) {
            strStopTask.append("    <stop host=\"localhost\" port=\"1400\"/>\n");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("def.name", defName.toLowerCase(Locale.US));
        map.put("mbean.class", def.getRaPackage() + ".mbean." + def.getMbeanInterfaceClass());
        map.put("start.task", strStartTask.toString());
        map.put("stop.task", strStopTask.toString());
        SimpleTemplate template = new SimpleTemplate(buildString);
        template.process(map, out);
    }
}

