/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.xml;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.SimpleTemplate;
import org.ironjacamar.codegenerator.Utils;
import org.ironjacamar.codegenerator.xml.AbstractXmlGen;

public class PomXmlGen
extends AbstractXmlGen {
    @Override
    public void writeXmlBody(Definition def, Writer out) throws IOException {
        String moduleName;
        URL buildFile = PomXmlGen.class.getResource("/pom.xml.template");
        String buildString = Utils.readFileIntoString(buildFile);
        String packageName = "";
        int pos = def.getRaPackage().lastIndexOf(".");
        if (pos > 0) {
            packageName = def.getRaPackage().substring(0, pos);
            moduleName = def.getRaPackage().substring(pos + 1);
        } else {
            moduleName = def.getRaPackage();
        }
        String raxml = def.isUseAnnotation() ? "" : "<raXmlFile>src/main/resources/META-INF/ra.xml</raXmlFile>";
        StringBuilder strStartGoal = new StringBuilder();
        StringBuilder strStopGoal = new StringBuilder();
        if (def.isSupportEis()) {
            strStartGoal.append("       <plugin>\n");
            strStartGoal.append("         <groupId>org.jboss.ironjacamar</groupId>\n");
            strStartGoal.append("         <artifactId>ironjacamar-test-eis</artifactId>\n");
            strStartGoal.append("         <version>${version.org.jboss.ironjacamar}</version>\n");
            strStartGoal.append("         <executions>\n");
            strStartGoal.append("           <execution>\n");
            strStartGoal.append("             <goals>\n");
            strStartGoal.append("               <goal>start</goal>\n");
            strStartGoal.append("             </goals>\n");
            strStartGoal.append("           </execution>\n");
            strStartGoal.append("         </executions>\n");
            strStartGoal.append("         <configuration>\n");
            strStartGoal.append("           <host>localhost</host>\n");
            strStartGoal.append("           <port>1400</port>\n");
            strStartGoal.append("           <handler>").append(def.getRaPackage()).append(".").append(def.getDefaultValue()).append("Handler</handler>\n");
            strStartGoal.append("           <classpath>\n");
            strStartGoal.append("             <param>target/test-classes</param>\n");
            strStartGoal.append("           </classpath>\n");
            strStartGoal.append("         </configuration>\n");
            strStartGoal.append("       </plugin>\n");
            strStopGoal.append("       <plugin>\n");
            strStopGoal.append("         <groupId>org.jboss.ironjacamar</groupId>\n");
            strStopGoal.append("         <artifactId>ironjacamar-test-eis</artifactId>\n");
            strStopGoal.append("         <version>${version.org.jboss.ironjacamar}</version>\n");
            strStopGoal.append("         <executions>\n");
            strStopGoal.append("           <execution>\n");
            strStopGoal.append("             <goals>\n");
            strStopGoal.append("               <goal>stop</goal>\n");
            strStopGoal.append("             </goals>\n");
            strStopGoal.append("           </execution>\n");
            strStopGoal.append("         </executions>\n");
            strStopGoal.append("         <configuration>\n");
            strStopGoal.append("           <host>localhost</host>\n");
            strStopGoal.append("           <port>1400</port>\n");
            strStopGoal.append("         </configuration>\n");
            strStopGoal.append("       </plugin>\n");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pom.package.name", packageName);
        map.put("pom.module.name", moduleName);
        map.put("raxml.file", raxml);
        map.put("start.goal", strStartGoal.toString());
        map.put("stop.goal", strStopGoal.toString());
        SimpleTemplate template = new SimpleTemplate(buildString);
        template.process(map, out);
    }
}

