/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.api.util.JarFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.ironjacamar.deployers.common.AbstractResourceAdapterDeployer;

public abstract class AbstractFungalRADeployer
extends AbstractResourceAdapterDeployer {
    protected URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles((FilenameFilter)new JarFilter());
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    protected boolean isRarArchive(URL url) {
        if (url == null) {
            return false;
        }
        return this.isRarFile(url) || this.isRarDirectory(url);
    }

    protected boolean isRarFile(URL url) {
        return url != null && url.toExternalForm().endsWith(".rar") && !url.toExternalForm().startsWith("jar");
    }

    protected boolean isRarDirectory(URL url) {
        return url != null && url.toExternalForm().endsWith(".rar/") && !url.toExternalForm().startsWith("jar");
    }
}

