/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.net.URL;
import org.ironjacamar.common.annotations.Annotations;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.spi.annotations.repository.AnnotationRepository;
import org.ironjacamar.common.spi.annotations.repository.AnnotationScanner;
import org.ironjacamar.common.spi.annotations.repository.AnnotationScannerFactory;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.jboss.logging.Logger;

public class AnnotationsDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)AnnotationsDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return this.isRarArchive(deployment);
    }

    public int getOrder() {
        return 3;
    }

    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        File archive = (File)context.get((Object)"archive");
        if (archive == null) {
            throw new DeployException("Deployment " + url.toExternalForm() + " not found");
        }
        Connector c = (Connector)context.get((Object)"raxml");
        if (c != null && (Connector.Version.V_10.equals((Object)c.getVersion()) || Connector.Version.V_15.equals((Object)c.getVersion()))) {
            return null;
        }
        if (c != null && c.isMetadataComplete()) {
            return null;
        }
        try {
            KernelClassLoader cl = (KernelClassLoader)context.get((Object)"classloader");
            Annotations processor = new Annotations();
            AnnotationScanner scanner = AnnotationScannerFactory.getAnnotationScanner();
            AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
            Connector merged = processor.merge(c, repository, (ClassLoader)cl);
            context.put((Object)"merged", (Object)merged);
            return null;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        return new AnnotationsDeployer();
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

