/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.Activations;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.metadata.merge.Merger;
import org.ironjacamar.common.metadata.resourceadapter.ResourceAdapterParser;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.metadatarepository.Metadata;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.ironjacamar.embedded.deployers.ActivationDeployment;
import org.ironjacamar.embedded.deployers.ClassLoaderDeployer;
import org.jboss.logging.Logger;

public class DashRaXmlDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)DashRaXmlDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return deployment != null && deployment.toExternalForm().endsWith("-ra.xml");
    }

    public int getOrder() {
        return 7;
    }

    public com.github.fungal.spi.deployers.Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        FileInputStream fis = null;
        try {
            File dashRaXml = new File(url.toURI());
            ResourceAdapterParser parser = new ResourceAdapterParser();
            fis = new FileInputStream(dashRaXml);
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(fis);
            Activations activations = parser.parse(xsr);
            Merger merger = new Merger();
            ClassLoaderDeployer classLoaderDeployer = (ClassLoaderDeployer)((Object)context.getKernel().getBean("ClassLoaderDeployer", ClassLoaderDeployer.class));
            ArrayList<Deployment> deployments = new ArrayList<Deployment>();
            for (Activation activation : activations.getActivations()) {
                Metadata metadata = this.metadataRepository.findByName(activation.getArchive());
                if (metadata == null) {
                    throw new DeployException("Deployment " + activation.getArchive() + " not found");
                }
                Connector c = metadata.getMetadata();
                File archive = metadata.getArchive();
                Connector actC = merger.merge((Connector)c.copy(), activation);
                context.put((Object)"archive", (Object)archive);
                classLoaderDeployer.clone().deploy(url, context, parent);
                KernelClassLoader cl = (KernelClassLoader)context.get((Object)"classloader");
                deployments.add(this.activate(actC, activation, activation.getArchive(), archive, (ClassLoader)cl));
            }
            ActivationDeployment activationDeployment = new ActivationDeployment(url, deployments, this.deploymentRepository, ((Deployment)deployments.get(0)).getClassLoader());
            return activationDeployment;
        }
        catch (DeployException de) {
            log.error((Object)de.getMessage(), (Throwable)de);
            throw de;
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        DashRaXmlDeployer d = new DashRaXmlDeployer();
        d.setDeploymentRepository(this.deploymentRepository);
        d.setMetadataRepository(this.metadataRepository);
        d.setBootstrapContextCoordinator(this.bootstrapContextCoordinator);
        d.setJndiStrategy(this.jndiStrategy);
        d.setTransactionIntegration(this.transactionIntegration);
        d.setCachedConnectionManager(this.cachedConnectionManager);
        d.setSubjectFactory(this.subjectFactory);
        d.setClassLoaderPlugin(this.classLoaderPlugin);
        d.setBeanValidation(this.beanValidation);
        d.setDefaultPoolType(this.defaultPoolType);
        d.setArchiveValidation(this.archiveValidation);
        d.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        d.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        return d;
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

