/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.metadata.ironjacamar.IronJacamarParser;
import org.ironjacamar.common.metadata.merge.Merger;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.jboss.logging.Logger;

public class IronJacamarXmlDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)IronJacamarXmlDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return this.isRarArchive(deployment);
    }

    public int getOrder() {
        return 6;
    }

    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        File archive = (File)context.get((Object)"archive");
        if (archive == null) {
            throw new DeployException("Deployment " + url.toExternalForm() + " not found");
        }
        FileInputStream fis = null;
        try {
            File ijXml = new File(archive, "META-INF/ironjacamar.xml");
            if (ijXml.exists()) {
                IronJacamarParser parser = new IronJacamarParser();
                fis = new FileInputStream(ijXml);
                XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(fis);
                Activation a = parser.parse(xsr);
                Connector c = (Connector)context.get((Object)"merged");
                if (c == null) {
                    c = (Connector)context.get((Object)"raxml");
                }
                KernelClassLoader cl = (KernelClassLoader)context.get((Object)"classloader");
                Merger merger = new Merger();
                Connector actC = merger.merge((Connector)c.copy(), a);
                this.activate(actC, a, archive.getName(), archive, (ClassLoader)cl);
            }
            Deployment deployment = null;
            return deployment;
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        IronJacamarXmlDeployer i = new IronJacamarXmlDeployer();
        i.setDeploymentRepository(this.deploymentRepository);
        i.setMetadataRepository(this.metadataRepository);
        i.setBootstrapContextCoordinator(this.bootstrapContextCoordinator);
        i.setJndiStrategy(this.jndiStrategy);
        i.setTransactionIntegration(this.transactionIntegration);
        i.setCachedConnectionManager(this.cachedConnectionManager);
        i.setSubjectFactory(this.subjectFactory);
        i.setClassLoaderPlugin(this.classLoaderPlugin);
        i.setBeanValidation(this.beanValidation);
        i.setDefaultPoolType(this.defaultPoolType);
        i.setArchiveValidation(this.archiveValidation);
        i.setArchiveValidationFailOnWarn(this.archiveValidationFailOnWarn);
        i.setArchiveValidationFailOnError(this.archiveValidationFailOnError);
        return i;
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

