/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.net.URL;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.core.api.metadatarepository.Metadata;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.ironjacamar.embedded.deployers.MetadataDeployment;
import org.jboss.logging.Logger;

public class MetadataDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)MetadataDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return this.isRarArchive(deployment);
    }

    public int getOrder() {
        return 5;
    }

    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        Connector c = (Connector)context.get((Object)"merged");
        if (c == null) {
            c = (Connector)context.get((Object)"raxml");
        }
        if (c == null) {
            throw new DeployException("No metadata for " + url.toExternalForm() + " found");
        }
        try {
            File archive = new File(url.toURI());
            Metadata m = this.registerMetadata(archive.getName(), (Connector)c.copy(), archive);
            return new MetadataDeployment(url, m, this.metadataRepository);
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        MetadataDeployer m = new MetadataDeployer();
        m.setMetadataRepository(this.metadataRepository);
        return m;
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

