/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.metadata.spec.RaParser;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.jboss.logging.Logger;

public class RaXmlMetadataDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RaXmlMetadataDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return this.isRarArchive(deployment);
    }

    public int getOrder() {
        return 2;
    }

    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        File archive = (File)context.get((Object)"archive");
        if (archive == null) {
            throw new DeployException("Deployment " + url.toExternalForm() + " not found");
        }
        FileInputStream fis = null;
        try {
            File raXml = new File(archive, "META-INF/ra.xml");
            if (raXml.exists()) {
                RaParser parser = new RaParser();
                fis = new FileInputStream(raXml);
                XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(fis);
                Connector c = parser.parse(xsr);
                context.put((Object)"raxml", (Object)c);
            }
            Deployment deployment = null;
            return deployment;
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        return new RaXmlMetadataDeployer();
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

