/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.deployers;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.embedded.deployers.AbstractFungalRADeployer;
import org.ironjacamar.embedded.deployers.SecurityActions;
import org.ironjacamar.embedded.deployers.TempDirectoryDeployment;
import org.jboss.logging.Logger;

public class RarFileExtractorDeployer
extends AbstractFungalRADeployer
implements CloneableDeployer {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RarFileExtractorDeployer.class.getName());

    public boolean accepts(URL deployment) {
        return this.isRarArchive(deployment);
    }

    public int getOrder() {
        return 0;
    }

    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        boolean extracted = false;
        File destination = null;
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            File root = null;
            if (f.isFile()) {
                FileUtil fileUtil = new FileUtil();
                destination = new File(SecurityActions.getSystemProperty("ironjacamar.home"), "/tmp/");
                root = fileUtil.extract(f, destination);
                extracted = true;
            } else {
                root = f;
            }
            context.put((Object)"archive", (Object)root);
            if (extracted) {
                return new TempDirectoryDeployment(url, root);
            }
            return null;
        }
        catch (Throwable t) {
            if (destination != null) {
                try {
                    FileUtil fileUtil = new FileUtil();
                    fileUtil.delete(destination);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    public Deployer clone() throws CloneNotSupportedException {
        return new RarFileExtractorDeployer();
    }

    protected DeployersLogger getLogger() {
        return log;
    }
}

