/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.embedded.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.ironjacamar.embedded.Configuration;
import org.ironjacamar.embedded.Deployment;
import org.ironjacamar.embedded.Embedded;
import org.ironjacamar.embedded.EmbeddedFactory;
import org.ironjacamar.embedded.junit4.Beans;
import org.ironjacamar.embedded.junit4.Condition;
import org.ironjacamar.embedded.junit4.ConditionException;
import org.ironjacamar.embedded.junit4.EmbeddedJCAResolver;
import org.ironjacamar.embedded.junit4.Finalizer;
import org.ironjacamar.embedded.junit4.Initializer;
import org.ironjacamar.embedded.junit4.PostCondition;
import org.ironjacamar.embedded.junit4.PreCondition;
import org.ironjacamar.embedded.junit4.SecurityActions;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class IronJacamar
extends BlockJUnit4ClassRunner {
    private Embedded embedded = null;
    private List<Object> staticDeployments = new ArrayList<Object>();
    private List<Object> deployments = new ArrayList<Object>();

    public IronJacamar(Class<?> clz) throws InitializationError {
        super(clz);
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, final Statement statement) {
        final Statement befores = super.withBefores(method, target, (Statement)new NoopStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                List fields;
                TestClass tc = IronJacamar.this.getTestClass();
                List fms = tc.getAnnotatedMethods(Deployment.class);
                if (fms != null && !fms.isEmpty()) {
                    Collection filtered = IronJacamar.this.filterAndSort(fms, false);
                    for (FrameworkMethod fm : filtered) {
                        URL result;
                        Object[] parameters;
                        SecurityActions.setAccessible(fm.getMethod());
                        Class returnType = fm.getReturnType();
                        if (URL.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (URL)fm.invokeExplosively(target, parameters);
                            IronJacamar.this.embedded.deploy(result);
                            IronJacamar.this.deployments.add(result);
                            continue;
                        }
                        if (ResourceAdapterArchive.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (ResourceAdapterArchive)fm.invokeExplosively(target, parameters);
                            IronJacamar.this.embedded.deploy((ResourceAdapterArchive)result);
                            IronJacamar.this.deployments.add(result);
                            continue;
                        }
                        if (Descriptor.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (Descriptor)fm.invokeExplosively(target, parameters);
                            IronJacamar.this.embedded.deploy((Descriptor)result);
                            IronJacamar.this.deployments.add(result);
                            continue;
                        }
                        throw new Exception("Unsupported deployment type: " + returnType.getName());
                    }
                }
                if ((fields = tc.getAnnotatedFields(Inject.class)) != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        Object value;
                        if (Modifier.isStatic(f.getField().getModifiers())) continue;
                        SecurityActions.setAccessible(f.getField());
                        if (Embedded.class.equals((Object)f.getType())) {
                            f.getField().set(target, IronJacamar.this.embedded);
                            continue;
                        }
                        Named name = (Named)f.getAnnotation(Named.class);
                        if (name != null && name.value() != null) {
                            value = IronJacamar.this.embedded.lookup(name.value(), f.getType());
                            f.getField().set(target, value);
                            continue;
                        }
                        value = IronJacamar.this.embedded.lookup(f.getType().getSimpleName(), f.getType());
                        f.getField().set(target, value);
                    }
                }
                if ((fields = tc.getAnnotatedFields(Resource.class)) != null && !fields.isEmpty()) {
                    Context context = IronJacamar.this.createContext();
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (Modifier.isStatic(f.getField().getModifiers())) continue;
                        Resource resource = (Resource)f.getAnnotation(Resource.class);
                        String name = null;
                        if (resource.mappedName() != null) {
                            name = resource.mappedName();
                        } else if (resource.name() != null) {
                            name = resource.name();
                        } else if (resource.lookup() != null) {
                            name = resource.lookup();
                        }
                        f.getField().set(target, context.lookup(name));
                    }
                    context.close();
                }
                befores.evaluate();
                statement.evaluate();
            }
        };
    }

    protected Statement withAfters(FrameworkMethod method, final Object target, final Statement statement) {
        final Statement afters = super.withAfters(method, target, (Statement)new NoopStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                statement.evaluate();
                afters.evaluate();
                TestClass tc = IronJacamar.this.getTestClass();
                List fields = tc.getAnnotatedFields(Resource.class);
                if (fields != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (Modifier.isStatic(f.getField().getModifiers()) || f.getField().getDeclaringClass().isPrimitive()) continue;
                        f.getField().set(target, null);
                    }
                }
                if ((fields = tc.getAnnotatedFields(Inject.class)) != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (Modifier.isStatic(f.getField().getModifiers()) || f.getField().getDeclaringClass().isPrimitive()) continue;
                        f.getField().set(target, null);
                    }
                }
                if (!IronJacamar.this.deployments.isEmpty()) {
                    for (int i = IronJacamar.this.deployments.size() - 1; i >= 0; --i) {
                        Object deployment = IronJacamar.this.deployments.get(i);
                        if (deployment instanceof URL) {
                            IronJacamar.this.embedded.undeploy((URL)deployment);
                            continue;
                        }
                        if (deployment instanceof ResourceAdapterArchive) {
                            IronJacamar.this.embedded.undeploy((ResourceAdapterArchive)deployment);
                            continue;
                        }
                        if (!(deployment instanceof Descriptor)) continue;
                        IronJacamar.this.embedded.undeploy((Descriptor)deployment);
                    }
                }
                IronJacamar.this.deployments.clear();
            }
        };
    }

    protected Statement withBeforeClasses(final Statement statement) {
        final Statement beforeClasses = super.withBeforeClasses((Statement)new NoopStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                List fields;
                List fms;
                PreCondition preCondition;
                TestClass tc = IronJacamar.this.getTestClass();
                boolean fullProfile = true;
                Configuration configuration = (Configuration)tc.getAnnotation(Configuration.class);
                if (configuration != null) {
                    fullProfile = configuration.full();
                }
                IronJacamar.this.extensionStart(tc);
                IronJacamar.this.embedded = EmbeddedFactory.create(fullProfile);
                IronJacamar.this.embedded.startup();
                Initializer initializer = (Initializer)tc.getAnnotation(Initializer.class);
                if (initializer != null && initializer.clazz() != null) {
                    try {
                        Class<? extends Beans> iClz = initializer.clazz();
                        Beans bC = iClz.newInstance();
                        bC.execute(new EmbeddedJCAResolver(IronJacamar.this.embedded));
                    }
                    catch (Exception e) {
                        throw new Exception("Initializer error from: " + initializer.clazz(), e);
                    }
                }
                if ((preCondition = (PreCondition)tc.getAnnotation(PreCondition.class)) != null && preCondition.condition() != null) {
                    try {
                        Class<? extends Condition> pCClz = preCondition.condition();
                        Condition pC = pCClz.newInstance();
                        pC.verify(new EmbeddedJCAResolver(IronJacamar.this.embedded));
                    }
                    catch (Exception e) {
                        throw new ConditionException("PreCondition error from: " + preCondition.condition(), e);
                    }
                }
                if ((fms = tc.getAnnotatedMethods(Deployment.class)) != null && !fms.isEmpty()) {
                    Collection filtered = IronJacamar.this.filterAndSort(fms, true);
                    for (FrameworkMethod fm : filtered) {
                        URL result;
                        Object[] parameters;
                        SecurityActions.setAccessible(fm.getMethod());
                        Class returnType = fm.getReturnType();
                        if (URL.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (URL)fm.invokeExplosively(null, parameters);
                            IronJacamar.this.embedded.deploy(result);
                            IronJacamar.this.staticDeployments.add(result);
                            continue;
                        }
                        if (ResourceAdapterArchive.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (ResourceAdapterArchive)fm.invokeExplosively(null, parameters);
                            IronJacamar.this.embedded.deploy((ResourceAdapterArchive)result);
                            IronJacamar.this.staticDeployments.add(result);
                            continue;
                        }
                        if (Descriptor.class.isAssignableFrom(returnType)) {
                            parameters = IronJacamar.this.getParameters(fm);
                            result = (Descriptor)fm.invokeExplosively(null, parameters);
                            IronJacamar.this.embedded.deploy((Descriptor)result);
                            IronJacamar.this.staticDeployments.add(result);
                            continue;
                        }
                        throw new Exception("Unsupported deployment type: " + returnType.getName());
                    }
                }
                if ((fields = tc.getAnnotatedFields(Inject.class)) != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        Object value;
                        if (!Modifier.isStatic(f.getField().getModifiers())) continue;
                        SecurityActions.setAccessible(f.getField());
                        if (Embedded.class.equals((Object)f.getType())) {
                            f.getField().set(null, IronJacamar.this.embedded);
                            continue;
                        }
                        Named name = (Named)f.getAnnotation(Named.class);
                        if (name != null && name.value() != null) {
                            value = IronJacamar.this.embedded.lookup(name.value(), f.getType());
                            f.getField().set(null, value);
                            continue;
                        }
                        value = IronJacamar.this.embedded.lookup(f.getType().getSimpleName(), f.getType());
                        f.getField().set(null, value);
                    }
                }
                if ((fields = tc.getAnnotatedFields(Resource.class)) != null && !fields.isEmpty()) {
                    Context context = IronJacamar.this.createContext();
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (!Modifier.isStatic(f.getField().getModifiers())) continue;
                        Resource resource = (Resource)f.getAnnotation(Resource.class);
                        String name = null;
                        if (resource.mappedName() != null) {
                            name = resource.mappedName();
                        } else if (resource.name() != null) {
                            name = resource.name();
                        } else if (resource.lookup() != null) {
                            name = resource.lookup();
                        }
                        f.getField().set(null, context.lookup(name));
                    }
                    context.close();
                }
                beforeClasses.evaluate();
                statement.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(final Statement statement) {
        final Statement afterClasses = super.withAfterClasses((Statement)new NoopStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                Finalizer finalizer;
                statement.evaluate();
                afterClasses.evaluate();
                TestClass tc = IronJacamar.this.getTestClass();
                List fields = tc.getAnnotatedFields(Resource.class);
                if (fields != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (!Modifier.isStatic(f.getField().getModifiers()) || f.getField().getDeclaringClass().isPrimitive()) continue;
                        f.getField().set(null, null);
                    }
                }
                if ((fields = tc.getAnnotatedFields(Inject.class)) != null && !fields.isEmpty()) {
                    for (FrameworkField f : fields) {
                        SecurityActions.setAccessible(f.getField());
                        if (!Modifier.isStatic(f.getField().getModifiers()) || f.getField().getDeclaringClass().isPrimitive()) continue;
                        f.getField().set(null, null);
                    }
                }
                if (!IronJacamar.this.staticDeployments.isEmpty()) {
                    for (int i = IronJacamar.this.staticDeployments.size() - 1; i >= 0; --i) {
                        Object deployment = IronJacamar.this.staticDeployments.get(i);
                        if (deployment instanceof URL) {
                            IronJacamar.this.embedded.undeploy((URL)deployment);
                            continue;
                        }
                        if (deployment instanceof ResourceAdapterArchive) {
                            IronJacamar.this.embedded.undeploy((ResourceAdapterArchive)deployment);
                            continue;
                        }
                        if (!(deployment instanceof Descriptor)) continue;
                        IronJacamar.this.embedded.undeploy((Descriptor)deployment);
                    }
                }
                IronJacamar.this.staticDeployments.clear();
                PostCondition postCondition = (PostCondition)tc.getAnnotation(PostCondition.class);
                if (postCondition != null && postCondition.condition() != null) {
                    try {
                        Class<? extends Condition> pCClz = postCondition.condition();
                        Condition pC = pCClz.newInstance();
                        pC.verify(new EmbeddedJCAResolver(IronJacamar.this.embedded));
                    }
                    catch (Exception e) {
                        throw new ConditionException("PostCondition error from: " + postCondition.condition(), e);
                    }
                }
                if ((finalizer = (Finalizer)tc.getAnnotation(Finalizer.class)) != null && finalizer.clazz() != null) {
                    try {
                        Class<? extends Beans> fClz = finalizer.clazz();
                        Beans fC = fClz.newInstance();
                        fC.execute(new EmbeddedJCAResolver(IronJacamar.this.embedded));
                    }
                    catch (Exception e) {
                        throw new Exception("Finalizer error from: " + finalizer.clazz(), e);
                    }
                }
                IronJacamar.this.embedded.shutdown();
                IronJacamar.this.embedded = null;
                IronJacamar.this.extensionStop(tc);
            }
        };
    }

    public void extensionStart(TestClass tc) throws Exception {
    }

    public void extensionStop(TestClass tc) throws Exception {
    }

    private Collection<FrameworkMethod> filterAndSort(List<FrameworkMethod> fms, boolean isStatic) throws Exception {
        TreeMap<Integer, FrameworkMethod> m = new TreeMap<Integer, FrameworkMethod>();
        for (FrameworkMethod fm : fms) {
            SecurityActions.setAccessible(fm.getMethod());
            if (Modifier.isStatic(fm.getMethod().getModifiers()) != isStatic) continue;
            Deployment deployment = (Deployment)fm.getAnnotation(Deployment.class);
            int order = deployment.order();
            if (order <= 0 || m.containsKey(order)) {
                throw new Exception("Incorrect order definition '" + order + "' on " + fm.getDeclaringClass().getName() + "#" + fm.getName());
            }
            m.put(order, fm);
        }
        return m.values();
    }

    private Object[] getParameters(FrameworkMethod fm) {
        Method m = fm.getMethod();
        SecurityActions.setAccessible(m);
        Class<?>[] parameters = m.getParameterTypes();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        Object[] result = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Annotation[] parameterAnnotation = parameterAnnotations[i];
            boolean inject = false;
            String name = null;
            for (int j = 0; j < parameterAnnotation.length; ++j) {
                Annotation a = parameterAnnotation[j];
                if (Inject.class.equals(a.annotationType())) {
                    inject = true;
                    continue;
                }
                if (!Named.class.equals(a.annotationType())) continue;
                name = ((Named)a).value();
            }
            result[i] = inject ? this.resolveBean(name != null ? name : parameters[i].getSimpleName(), parameters[i]) : null;
        }
        return result;
    }

    private Object resolveBean(String name, Class<?> type) {
        try {
            return this.embedded.lookup(name, type);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Context createContext() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "org.jnp.interfaces.LocalOnlyContextFactory");
        properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        return new InitialContext(properties);
    }

    private static class NoopStatement
    extends Statement {
        private NoopStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }
}

