/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.annotations.repository.jandex;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.annotations.repository.jandex.SecurityActions;
import org.ironjacamar.common.spi.annotations.repository.Annotation;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class AnnotationImpl
implements Annotation {
    private static Logger log = Logger.getLogger(AnnotationImpl.class);
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private String className;
    private ClassLoader cl;
    private List<String> parameterTypes;
    private String memberName;
    private boolean onMethod;
    private boolean onField;
    private Class<? extends java.lang.annotation.Annotation> annotationClass;

    public AnnotationImpl(String className, ClassLoader cl, List<String> parameterTypes, String memberName, boolean onMethod, boolean onField, Class<?> annotationClass) {
        this.className = className;
        this.cl = cl;
        if (parameterTypes != null) {
            this.parameterTypes = new ArrayList<String>(parameterTypes.size());
            this.parameterTypes.addAll(parameterTypes);
        } else {
            this.parameterTypes = new ArrayList<String>(0);
        }
        this.memberName = memberName;
        this.onMethod = onMethod;
        this.onField = onField;
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException(bundle.annotationClassShouldBeAnnotation());
        }
        this.annotationClass = annotationClass;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Object getAnnotation() {
        block11: {
            try {
                if (this.isOnField()) {
                    Class<?> clazz = this.cl.loadClass(this.className);
                    while (!clazz.equals(Object.class)) {
                        try {
                            Field field = SecurityActions.getDeclaredField(clazz, this.memberName);
                            return field.getAnnotation(this.annotationClass);
                        }
                        catch (Throwable t) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    break block11;
                }
                if (this.isOnMethod()) {
                    Class<?> clazz = this.cl.loadClass(this.className);
                    Class[] params = new Class[this.parameterTypes.size()];
                    int i = 0;
                    for (String paramClazz : this.parameterTypes) {
                        params[i] = this.cl.loadClass(paramClazz);
                        ++i;
                    }
                    while (!clazz.equals(Object.class)) {
                        try {
                            Method method = SecurityActions.getDeclaredMethod(clazz, this.memberName, params);
                            return method.getAnnotation(this.annotationClass);
                        }
                        catch (Throwable t) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    break block11;
                }
                Class<?> clazz = this.cl.loadClass(this.className);
                return clazz.getAnnotation(this.annotationClass);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<String> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public boolean isOnMethod() {
        return this.onMethod;
    }

    @Override
    public boolean isOnField() {
        return this.onField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[className=").append(this.className);
        sb.append(" cl=").append(this.cl);
        sb.append(" parameterTypes=").append(this.parameterTypes);
        sb.append(" memberName=").append(this.memberName);
        sb.append(" onMethod=").append(this.onMethod);
        sb.append(" onField=").append(this.onField);
        sb.append(" annotationClass=").append(this.annotationClass);
        sb.append("]");
        return sb.toString();
    }
}

