/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.api.metadata;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.common.CommonLogger;
import org.ironjacamar.common.spi.metadata.Parser;
import org.jboss.logging.Logger;

public class ParserFactory {
    private static CommonLogger log;
    public static final int RA_XML = 0;
    public static final int IRONJACAMAR_XML = 1;
    public static final int DASH_RA_XML = 2;
    private static Map<Integer, Parser> parsers;

    private ParserFactory() {
    }

    public static Parser getParser(int type) {
        return parsers.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block22: {
            log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)ParserFactory.class.getName());
            parsers = new HashMap<Integer, Parser>();
            try {
                Enumeration<URL> enumeration = ParserFactory.class.getClassLoader().getResources("META-INF/services/org.ironjacamar.metadata.XmlParser");
                if (enumeration == null) break block22;
                while (enumeration.hasMoreElements()) {
                    URL u = enumeration.nextElement();
                    InputStream is = null;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        int b;
                        is = u.openStream();
                        is = new BufferedInputStream(is, 8192);
                        while ((b = is.read()) != -1) {
                            os.write(b);
                        }
                        os.flush();
                        String clz = new String(os.toByteArray(), "UTF-8");
                        Class<?> c = Class.forName(clz, true, ParserFactory.class.getClassLoader());
                        Parser p = (Parser)c.newInstance();
                        parsers.put(p.getType(), p);
                    }
                    catch (Exception e) {
                        log.debug(e.getMessage(), e);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (os == null) continue;
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception e) {
                log.debug(e.getMessage(), e);
            }
        }
    }
}

