/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.api.metadata.spec;

import org.ironjacamar.common.CommonBundle;
import org.jboss.logging.Messages;

public enum CredentialInterfaceEnum {
    PasswordCredential("javax.resource.spi.security.PasswordCredential"),
    GSSCredential("org.ietf.jgss.GSSCredential"),
    GenericCredential("javax.resource.spi.security.GenericCredential");

    private static CommonBundle bundle;
    private final String fullQualifiedName;

    private CredentialInterfaceEnum(String name) {
        this.fullQualifiedName = name;
    }

    public static CredentialInterfaceEnum forName(String fullQualifiedName) throws IllegalArgumentException {
        if ("javax.resource.spi.security.PasswordCredential".equals(fullQualifiedName)) {
            return PasswordCredential;
        }
        if ("org.ietf.jgss.GSSCredential".equals(fullQualifiedName)) {
            return GSSCredential;
        }
        if ("javax.resource.spi.security.GenericCredential".equals(fullQualifiedName)) {
            return GenericCredential;
        }
        throw new IllegalArgumentException(bundle.fullQualifiedName());
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public String toString() {
        return this.fullQualifiedName;
    }

    static {
        bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    }
}

