/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.ironjacamar.common.CommonLogger;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.metadata.ironjacamar.IronJacamarParser;
import org.ironjacamar.common.metadata.spec.RaParser;
import org.jboss.logging.Logger;

public class MetadataFactory {
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)MetadataFactory.class.getName());

    public Connector getStandardMetaData(File root) throws Exception {
        Connector result = null;
        File metadataFile = new File(root, "/META-INF/ra.xml");
        if (metadataFile.exists()) {
            String url = metadataFile.getAbsolutePath();
            try (InputStream input = null;){
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(input);
                result = new RaParser().parse(xsr);
                log.debugf("Total parse for %s took %d ms", url, System.currentTimeMillis() - start);
            }
        } else {
            log.tracef("metadata file %s does not exist", metadataFile.toString());
        }
        return result;
    }

    public Activation getIronJacamarMetaData(File root) throws Exception {
        Activation result = null;
        File metadataFile = new File(root, "/META-INF/ironjacamar.xml");
        if (metadataFile.exists()) {
            String url = metadataFile.getAbsolutePath();
            try (InputStream input = null;){
                long start = System.currentTimeMillis();
                input = new FileInputStream(metadataFile);
                XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(input);
                result = new IronJacamarParser().parse(xsr);
                log.debugf("Total parse for %s took %d ms", url, System.currentTimeMillis() - start);
            }
        }
        return result;
    }
}

