/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.CommonLogger;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Capacity;
import org.ironjacamar.common.api.metadata.common.Credential;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.common.api.metadata.common.Pool;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.metadata.common.Security;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.metadata.common.Validation;
import org.ironjacamar.common.api.metadata.common.XaPool;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.CapacityImpl;
import org.ironjacamar.common.metadata.common.CredentialImpl;
import org.ironjacamar.common.metadata.common.ExtensionImpl;
import org.ironjacamar.common.metadata.common.PoolImpl;
import org.ironjacamar.common.metadata.common.RecoveryImpl;
import org.ironjacamar.common.metadata.common.SecurityImpl;
import org.ironjacamar.common.metadata.common.StringUtils;
import org.ironjacamar.common.metadata.common.TimeoutImpl;
import org.ironjacamar.common.metadata.common.ValidationImpl;
import org.ironjacamar.common.metadata.common.XaPoolImpl;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public abstract class AbstractParser {
    protected static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)AbstractParser.class.getName());
    protected static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private boolean resolveSystemProperties = true;

    public boolean isSystemPropertiesResolved() {
        return this.resolveSystemProperties;
    }

    public void setSystemPropertiesResolved(boolean v) {
        this.resolveSystemProperties = v;
    }

    protected Boolean elementAsBoolean(XMLStreamReader reader, String key, Map<String, String> expressions) throws XMLStreamException, ParserException {
        String stringValue;
        String elementtext = this.rawElementText(reader);
        if (key != null && expressions != null && elementtext != null && elementtext.indexOf("${") != -1) {
            expressions.put(key, elementtext);
        }
        if (StringUtils.isEmpty(stringValue = this.getSubstitutionValue(elementtext)) || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return StringUtils.isEmpty(stringValue) ? Boolean.TRUE : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(bundle.elementAsBoolean(elementtext, reader.getLocalName()));
    }

    protected Boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, Boolean defaultValue, Map<String, String> expressions) throws XMLStreamException, ParserException {
        String stringValue;
        String attributeString = this.rawAttributeText(reader, attributeName);
        if (attributeName != null && expressions != null && attributeString != null && attributeString.indexOf("${") != -1) {
            expressions.put(attributeName, attributeString);
        }
        if (StringUtils.isEmpty(stringValue = this.getSubstitutionValue(attributeString)) || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return StringUtils.isEmpty(stringValue) ? defaultValue : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(bundle.attributeAsBoolean(attributeString, reader.getLocalName()));
    }

    protected String elementAsString(XMLStreamReader reader, String key, Map<String, String> expressions) throws XMLStreamException {
        String elementtext = this.rawElementText(reader);
        if (key != null && expressions != null && elementtext != null && elementtext.indexOf("${") != -1) {
            expressions.put(key, elementtext);
        }
        return this.getSubstitutionValue(elementtext);
    }

    private String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        if (elementtext == null) {
            return null;
        }
        return elementtext.trim();
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName, Map<String, String> expressions) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        if (attributeName != null && expressions != null && attributeString != null && attributeString.indexOf("${") != -1) {
            expressions.put(attributeName, attributeString);
        }
        return this.getSubstitutionValue(attributeString);
    }

    protected Integer attributeAsInt(XMLStreamReader reader, String attributeName, Map<String, String> expressions) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        if (attributeName != null && expressions != null && attributeString != null && attributeString.indexOf("${") != -1) {
            expressions.put(attributeName, attributeString);
        }
        return attributeString != null ? Integer.valueOf(this.getSubstitutionValue(attributeString)) : null;
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName);
        if (attributeString == null) {
            return null;
        }
        return attributeString.trim();
    }

    protected Integer elementAsInteger(XMLStreamReader reader, String key, Map<String, String> expressions) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        String elementtext = this.rawElementText(reader);
        if (key != null && expressions != null && elementtext != null && elementtext.indexOf("${") != -1) {
            expressions.put(key, elementtext);
        }
        try {
            integerValue = Integer.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader, String key, Map<String, String> expressions) throws XMLStreamException, ParserException {
        Long longValue = null;
        String elementtext = this.rawElementText(reader);
        if (key != null && expressions != null && elementtext != null && elementtext.indexOf("${") != -1) {
            expressions.put(key, elementtext);
        }
        try {
            longValue = Long.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(bundle.notValidNumber(elementtext, reader.getLocalName()));
        }
        return longValue;
    }

    protected FlushStrategy elementAsFlushStrategy(XMLStreamReader reader, Map<String, String> expressions) throws XMLStreamException, ParserException {
        FlushStrategy result;
        String elementtext = this.rawElementText(reader);
        if (expressions != null && elementtext != null && elementtext.indexOf("${") != -1) {
            expressions.put("flush-strategy", elementtext);
        }
        if ((result = FlushStrategy.forName(this.getSubstitutionValue(elementtext))) != FlushStrategy.UNKNOWN) {
            return result;
        }
        throw new ParserException(bundle.notValidFlushStrategy(elementtext));
    }

    protected Pool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String type = Defaults.TYPE;
        String janitor = Defaults.JANITOR;
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block41: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.attributeAsString(reader, "type", expressions);
                    continue block41;
                }
                case "janitor": {
                    janitor = this.attributeAsString(reader, "janitor", expressions);
                    continue block41;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "pool": {
                            return new PoolImpl(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, capacity, !expressions.isEmpty() ? expressions : null);
                        }
                        case "max-pool-size": 
                        case "min-pool-size": 
                        case "initial-pool-size": 
                        case "prefill": 
                        case "flush-strategy": 
                        case "capacity": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "max-pool-size": {
                            maxPoolSize = this.elementAsInteger(reader, "max-pool-size", expressions);
                            break block8;
                        }
                        case "min-pool-size": {
                            minPoolSize = this.elementAsInteger(reader, "min-pool-size", expressions);
                            break block8;
                        }
                        case "initial-pool-size": {
                            initialPoolSize = this.elementAsInteger(reader, "initial-pool-size", expressions);
                            break block8;
                        }
                        case "prefill": {
                            prefill = this.elementAsBoolean(reader, "prefill", expressions);
                            break block8;
                        }
                        case "flush-strategy": {
                            flushStrategy = this.elementAsFlushStrategy(reader, expressions);
                            break block8;
                        }
                        case "capacity": {
                            capacity = this.parseCapacity(reader);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected XaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String type = Defaults.TYPE;
        String janitor = Defaults.JANITOR;
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block50: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.attributeAsString(reader, "type", expressions);
                    continue block50;
                }
                case "janitor": {
                    janitor = this.attributeAsString(reader, "janitor", expressions);
                    continue block50;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "xa-pool": {
                            return new XaPoolImpl(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, capacity, isSameRmOverride, padXid, wrapXaDataSource, !expressions.isEmpty() ? expressions : null);
                        }
                        case "max-pool-size": 
                        case "initial-pool-size": 
                        case "min-pool-size": 
                        case "is-same-rm-override": 
                        case "pad-xid": 
                        case "wrap-xa-resource": 
                        case "prefill": 
                        case "flush-strategy": 
                        case "capacity": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "max-pool-size": {
                            maxPoolSize = this.elementAsInteger(reader, "max-pool-size", expressions);
                            break block8;
                        }
                        case "initial-pool-size": {
                            initialPoolSize = this.elementAsInteger(reader, "initial-pool-size", expressions);
                            break block8;
                        }
                        case "min-pool-size": {
                            minPoolSize = this.elementAsInteger(reader, "min-pool-size", expressions);
                            break block8;
                        }
                        case "is-same-rm-override": {
                            isSameRmOverride = this.elementAsBoolean(reader, "is-same-rm-override", expressions);
                            break block8;
                        }
                        case "pad-xid": {
                            padXid = this.elementAsBoolean(reader, "pad-xid", expressions);
                            break block8;
                        }
                        case "wrap-xa-resource": {
                            wrapXaDataSource = this.elementAsBoolean(reader, "wrap-xa-resource", expressions);
                            break block8;
                        }
                        case "prefill": {
                            prefill = this.elementAsBoolean(reader, "prefill", expressions);
                            break block8;
                        }
                        case "flush-strategy": {
                            flushStrategy = this.elementAsFlushStrategy(reader, expressions);
                            break block8;
                        }
                        case "capacity": {
                            capacity = this.parseCapacity(reader);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Security parseSecuritySettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String securityDomain = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "security": {
                            return new SecurityImpl(securityDomain, !expressions.isEmpty() ? expressions : null);
                        }
                        case "security-domain": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "security-domain": {
                            securityDomain = this.elementAsString(reader, "security-domain", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private String getSubstitutionValue(String input) {
        if (!this.resolveSystemProperties) {
            return input;
        }
        return StringUtils.transformExpression(input);
    }

    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String securityDomain = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "security": 
                        case "recovery-credential": {
                            return new CredentialImpl(securityDomain, !expressions.isEmpty() ? expressions : null);
                        }
                        case "security-domain": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "security-domain": {
                            securityDomain = this.elementAsString(reader, "security-domain", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Recovery parseRecovery(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean noRecovery = Defaults.NO_RECOVERY;
        Credential security = null;
        Extension plugin = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block27: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "no-recovery": {
                    noRecovery = this.attributeAsBoolean(reader, "no-recovery", Boolean.FALSE, expressions);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "recovery": {
                            return new RecoveryImpl(security, plugin, noRecovery, !expressions.isEmpty() ? expressions : null);
                        }
                        case "recovery-credential": 
                        case "recovery-plugin": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "recovery-credential": {
                            security = this.parseCredential(reader);
                            break block6;
                        }
                        case "recovery-plugin": {
                            plugin = this.parseExtension(reader, "recovery-plugin");
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Extension parseExtension(XMLStreamReader reader, String enclosingTag) throws XMLStreamException, ParserException, ValidateException {
        String className = null;
        String moduleName = null;
        String moduleSlot = null;
        HashMap<String, String> properties = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "class-name": {
                    className = this.attributeAsString(reader, "class-name", expressions);
                    continue block26;
                }
                case "module-name": {
                    moduleName = this.attributeAsString(reader, "module-name", expressions);
                    continue block26;
                }
                case "module-slot": {
                    moduleSlot = this.attributeAsString(reader, "module-slot", expressions);
                    continue block26;
                }
            }
        }
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (reader.getLocalName().equals(enclosingTag)) {
                        if (className == null) {
                            throw new ParserException(bundle.missingClassName(enclosingTag));
                        }
                        return new ExtensionImpl(className, moduleName, moduleSlot, properties, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            if (properties == null) {
                                properties = new HashMap<String, String>();
                            }
                            this.parseConfigProperty(properties, reader, "config-property", expressions);
                            break block10;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Capacity parseCapacity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Extension incrementer = null;
        Extension decrementer = null;
        block18: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "capacity": {
                            return new CapacityImpl(incrementer, decrementer);
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "incrementer": {
                            incrementer = this.parseExtension(reader, "incrementer");
                            break;
                        }
                        case "decrementer": {
                            decrementer = this.parseExtension(reader, "decrementer");
                            break;
                        }
                    }
                    continue block18;
                }
            }
            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Validation parseValidation(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Boolean useFastFail = Defaults.USE_FAST_FAIL;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        Long backgroundValidationMillis = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "validation": {
                            return new ValidationImpl(validateOnMatch, backgroundValidation, backgroundValidationMillis, useFastFail, !expressions.isEmpty() ? expressions : null);
                        }
                        case "validate-on-match": 
                        case "background-validation-millis": 
                        case "background-validation": 
                        case "use-fast-fail": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "validate-on-match": {
                            validateOnMatch = this.elementAsBoolean(reader, "validate-on-match", expressions);
                            break block0;
                        }
                        case "background-validation-millis": {
                            backgroundValidationMillis = this.elementAsLong(reader, "background-validation-millis", expressions);
                            break block0;
                        }
                        case "background-validation": {
                            backgroundValidation = this.elementAsBoolean(reader, "background-validation", expressions);
                            break block0;
                        }
                        case "use-fast-fail": {
                            useFastFail = this.elementAsBoolean(reader, "use-fast-fail", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Timeout parseTimeout(XMLStreamReader reader, Boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Long allocationRetryWaitMillis = null;
        Integer idleTimeoutMinutes = null;
        Integer allocationRetry = null;
        Integer xaResourceTimeout = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "timeout": {
                            return new TimeoutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, !expressions.isEmpty() ? expressions : null);
                        }
                        case "allocation-retry-wait-millis": 
                        case "allocation-retry": 
                        case "blocking-timeout-millis": 
                        case "idle-timeout-minutes": 
                        case "xa-resource-timeout": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "allocation-retry-wait-millis": {
                            allocationRetryWaitMillis = this.elementAsLong(reader, "allocation-retry-wait-millis", expressions);
                            break block0;
                        }
                        case "allocation-retry": {
                            allocationRetry = this.elementAsInteger(reader, "allocation-retry", expressions);
                            break block0;
                        }
                        case "blocking-timeout-millis": {
                            blockingTimeoutMillis = this.elementAsLong(reader, "blocking-timeout-millis", expressions);
                            break block0;
                        }
                        case "idle-timeout-minutes": {
                            idleTimeoutMinutes = this.elementAsInteger(reader, "idle-timeout-minutes", expressions);
                            break block0;
                        }
                        case "xa-resource-timeout": {
                            if (isXa != null && Boolean.FALSE.equals(isXa)) {
                                throw new ParserException(bundle.unsupportedElement(reader.getLocalName()));
                            }
                            xaResourceTimeout = this.elementAsInteger(reader, "xa-resource-timeout", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void storeCapacity(Capacity c, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("capacity");
        if (c.getIncrementer() != null) {
            this.storeExtension(c.getIncrementer(), writer, "incrementer");
        }
        if (c.getDecrementer() != null) {
            this.storeExtension(c.getDecrementer(), writer, "decrementer");
        }
        writer.writeEndElement();
    }

    protected void storeExtension(Extension e, XMLStreamWriter writer, String elementName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeAttribute("class-name", e.getValue("class-name", e.getClassName()));
        if (e.getModuleName() != null) {
            writer.writeAttribute("module-name", e.getValue("module-name", e.getModuleName()));
        }
        if (e.getModuleSlot() != null) {
            writer.writeAttribute("module-slot", e.getValue("module-slot", e.getModuleSlot()));
        }
        if (!e.getConfigPropertiesMap().isEmpty()) {
            for (Map.Entry<String, String> entry : e.getConfigPropertiesMap().entrySet()) {
                writer.writeStartElement("config-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(e.getValue("config-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void storeRecovery(Recovery r, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("recovery");
        if (r.isNoRecovery() != null) {
            writer.writeAttribute("no-recovery", r.getValue("no-recovery", r.isNoRecovery().toString()));
        }
        if (r.getCredential() != null) {
            writer.writeStartElement("recovery-credential");
            writer.writeStartElement("security-domain");
            writer.writeCharacters(r.getCredential().getValue("security-domain", r.getCredential().getSecurityDomain()));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (r.getPlugin() != null) {
            this.storeExtension(r.getPlugin(), writer, "recovery-plugin");
        }
        writer.writeEndElement();
    }

    protected void parseConfigProperty(Map<String, String> configProperties, XMLStreamReader reader, String key, Map<String, String> expressions) throws XMLStreamException, ParserException {
        String n = this.attributeAsString(reader, "name", null);
        if (StringUtils.isEmptyTrimmed(n)) {
            throw new ParserException(bundle.requiredAttributeMissing("name", reader.getLocalName()));
        }
        configProperties.put(n, this.elementAsString(reader, this.getExpressionKey(key, n), expressions));
    }

    protected String getExpressionKey(String k, String s) {
        return k + "|" + s;
    }
}

