/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Pool;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.metadata.common.Security;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.metadata.common.Validation;
import org.ironjacamar.common.api.metadata.common.XaPool;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.resourceadapter.WorkManager;
import org.ironjacamar.common.api.metadata.resourceadapter.WorkManagerSecurity;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.AbstractParser;
import org.ironjacamar.common.metadata.resourceadapter.AdminObjectImpl;
import org.ironjacamar.common.metadata.resourceadapter.ConnectionDefinitionImpl;
import org.ironjacamar.common.metadata.resourceadapter.WorkManagerImpl;
import org.ironjacamar.common.metadata.resourceadapter.WorkManagerSecurityImpl;
import org.jboss.logging.Messages;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected AdminObject parseAdminObjects(XMLStreamReader reader) throws XMLStreamException, ParserException {
        TreeMap<String, String> configProperties = new TreeMap<String, String>();
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String id = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        int attributeSize = reader.getAttributeCount();
        block28: for (int i = 0; i < attributeSize; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "enabled": {
                    enabled = this.attributeAsBoolean(reader, "enabled", true, expressions);
                    continue block28;
                }
                case "jndi-name": {
                    jndiName = this.attributeAsString(reader, "jndi-name", expressions);
                    continue block28;
                }
                case "class-name": {
                    className = this.attributeAsString(reader, "class-name", expressions);
                    continue block28;
                }
                case "id": {
                    id = this.attributeAsString(reader, "id", expressions);
                    continue block28;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(reader.getAttributeLocalName(i), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if ("admin-object".equals(reader.getLocalName())) {
                        return new AdminObjectImpl(configProperties, className, jndiName, id, enabled, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            this.parseConfigProperty(configProperties, reader, "config-property", expressions);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManager parseWorkManager(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        WorkManagerSecurity security = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("workmanager".equals(reader.getLocalName())) {
                        return new WorkManagerImpl(security);
                    }
                    switch (reader.getLocalName()) {
                        case "security": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "security": {
                            security = this.parseWorkManagerSecurity(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected WorkManagerSecurity parseWorkManagerSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        boolean mappingRequired = false;
        String domain = null;
        String defaultPrincipal = null;
        ArrayList<String> defaultGroups = null;
        HashMap<String, String> userMappings = null;
        HashMap<String, String> groupMappings = null;
        boolean userMappingEnabled = false;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("security".equals(reader.getLocalName())) {
                        return new WorkManagerSecurityImpl(mappingRequired, domain, defaultPrincipal, defaultGroups, userMappings, groupMappings, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "default-groups": 
                        case "mappings": 
                        case "mapping-required": 
                        case "domain": 
                        case "default-principal": 
                        case "group": 
                        case "users": 
                        case "groups": 
                        case "map": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "default-groups": 
                        case "mappings": {
                            break block0;
                        }
                        case "mapping-required": {
                            mappingRequired = this.elementAsBoolean(reader, "mapping-required", expressions);
                            break block0;
                        }
                        case "domain": {
                            domain = this.elementAsString(reader, "domain", expressions);
                            break block0;
                        }
                        case "default-principal": {
                            defaultPrincipal = this.elementAsString(reader, "default-principal", expressions);
                            break block0;
                        }
                        case "group": {
                            if (defaultGroups == null) {
                                defaultGroups = new ArrayList<String>(1);
                            }
                            defaultGroups.add(this.elementAsString(reader, this.getExpressionKey("group", Integer.toString(defaultGroups.size())), expressions));
                            break block0;
                        }
                        case "users": {
                            userMappingEnabled = true;
                            break block0;
                        }
                        case "groups": {
                            userMappingEnabled = false;
                            break block0;
                        }
                        case "map": {
                            String to;
                            String from;
                            if (userMappingEnabled) {
                                if (userMappings == null) {
                                    userMappings = new HashMap<String, String>();
                                }
                                if ((from = this.attributeAsString(reader, "from", expressions)) == null || from.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing("from", reader.getLocalName()));
                                }
                                to = this.attributeAsString(reader, "to", expressions);
                                if (to == null || to.trim().equals("")) {
                                    throw new ParserException(bundle.requiredAttributeMissing("to", reader.getLocalName()));
                                }
                                userMappings.put(from, to);
                                break block0;
                            }
                            if (groupMappings == null) {
                                groupMappings = new HashMap<String, String>();
                            }
                            if ((from = this.attributeAsString(reader, "from", expressions)) == null || from.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing("from", reader.getLocalName()));
                            }
                            to = this.attributeAsString(reader, "to", expressions);
                            if (to == null || to.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing("to", reader.getLocalName()));
                            }
                            groupMappings.put(from, to);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected ConnectionDefinition parseConnectionDefinitions(XMLStreamReader reader, Boolean isXA) throws XMLStreamException, ParserException, ValidateException {
        TreeMap<String, String> configProperties = new TreeMap<String, String>();
        Security security = null;
        Timeout timeout = null;
        Validation validation = null;
        Pool pool = null;
        Recovery recovery = null;
        String className = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        String id = null;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean sharable = Defaults.SHARABLE;
        Boolean enlistment = Defaults.ENLISTMENT;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        int attributeSize = reader.getAttributeCount();
        HashMap<String, String> expressions = new HashMap<String, String>();
        if (isXA == null) {
            isXA = Boolean.FALSE;
        }
        block56: for (int i = 0; i < attributeSize; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "enabled": {
                    enabled = this.attributeAsBoolean(reader, "enabled", Defaults.ENABLED, expressions);
                    continue block56;
                }
                case "jndi-name": {
                    jndiName = this.attributeAsString(reader, "jndi-name", expressions);
                    continue block56;
                }
                case "class-name": {
                    className = this.attributeAsString(reader, "class-name", expressions);
                    continue block56;
                }
                case "id": {
                    id = this.attributeAsString(reader, "id", expressions);
                    continue block56;
                }
                case "use-ccm": {
                    useCcm = this.attributeAsBoolean(reader, "use-ccm", Defaults.USE_CCM, expressions);
                    continue block56;
                }
                case "sharable": {
                    sharable = this.attributeAsBoolean(reader, "sharable", Defaults.SHARABLE, expressions);
                    continue block56;
                }
                case "enlistment": {
                    enlistment = this.attributeAsBoolean(reader, "enlistment", Defaults.ENLISTMENT, expressions);
                    continue block56;
                }
                case "connectable": {
                    connectable = this.attributeAsBoolean(reader, "connectable", Defaults.CONNECTABLE, expressions);
                    continue block56;
                }
                case "tracking": {
                    tracking = this.attributeAsBoolean(reader, "tracking", Defaults.TRACKING, expressions);
                    continue block56;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(reader.getAttributeLocalName(i), reader.getLocalName()));
                }
            }
        }
        if (jndiName == null || jndiName.trim().equals("")) {
            throw new ParserException(bundle.missingJndiName(reader.getLocalName()));
        }
        while (reader.hasNext()) {
            block22 : switch (reader.nextTag()) {
                case 2: {
                    if ("connection-definition".equals(reader.getLocalName())) {
                        return new ConnectionDefinitionImpl(configProperties, className, jndiName, id, enabled, useCcm, sharable, enlistment, connectable, tracking, pool, timeout, validation, security, recovery, isXA, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "config-property": 
                        case "security": 
                        case "timeout": 
                        case "validation": 
                        case "xa-pool": 
                        case "pool": 
                        case "recovery": {
                            break block22;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "config-property": {
                            this.parseConfigProperty(configProperties, reader, "config-property", expressions);
                            break block22;
                        }
                        case "security": {
                            security = this.parseSecuritySettings(reader);
                            break block22;
                        }
                        case "timeout": {
                            timeout = this.parseTimeout(reader, isXA);
                            break block22;
                        }
                        case "validation": {
                            validation = this.parseValidation(reader);
                            break block22;
                        }
                        case "xa-pool": {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parseXaPool(reader);
                            isXA = Boolean.TRUE;
                            break block22;
                        }
                        case "pool": {
                            if (pool != null) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            pool = this.parsePool(reader);
                            break block22;
                        }
                        case "recovery": {
                            recovery = this.parseRecovery(reader);
                            break block22;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void storeCommon(Activation a, XMLStreamWriter writer) throws Exception {
        if (a.getBeanValidationGroups() != null && !a.getBeanValidationGroups().isEmpty()) {
            writer.writeStartElement("bean-validation-groups");
            for (int i = 0; i < a.getBeanValidationGroups().size(); ++i) {
                writer.writeStartElement("bean-validation-group");
                writer.writeCharacters(a.getValue("bean-validation-group", Integer.toString(i), a.getBeanValidationGroups().get(i)));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (a.getBootstrapContext() != null) {
            writer.writeStartElement("bootstrap-context");
            writer.writeCharacters(a.getValue("bootstrap-context", a.getBootstrapContext()));
            writer.writeEndElement();
        }
        if (a.getConfigProperties() != null && !a.getConfigProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : a.getConfigProperties().entrySet()) {
                writer.writeStartElement("config-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(a.getValue("config-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        if (a.getTransactionSupport() != null) {
            writer.writeStartElement("transaction-support");
            writer.writeCharacters(a.getValue("transaction-support", a.getTransactionSupport().toString()));
            writer.writeEndElement();
        }
        if (a.getWorkManager() != null) {
            this.storeWorkManager(a.getWorkManager(), writer);
        }
        if (a.getConnectionDefinitions() != null && !a.getConnectionDefinitions().isEmpty()) {
            writer.writeStartElement("connection-definitions");
            for (ConnectionDefinition cd : a.getConnectionDefinitions()) {
                this.storeConnectionDefinition(cd, writer);
            }
            writer.writeEndElement();
        }
        if (a.getAdminObjects() != null && !a.getAdminObjects().isEmpty()) {
            writer.writeStartElement("admin-objects");
            for (AdminObject ao : a.getAdminObjects()) {
                this.storeAdminObject(ao, writer);
            }
            writer.writeEndElement();
        }
    }

    protected void storeWorkManager(WorkManager wm, XMLStreamWriter writer) throws Exception {
        WorkManagerSecurity s = wm.getSecurity();
        writer.writeStartElement("workmanager");
        writer.writeStartElement("security");
        writer.writeStartElement("mapping-required");
        writer.writeCharacters(s.getValue("mapping-required", Boolean.toString(s.isMappingRequired())));
        writer.writeEndElement();
        writer.writeStartElement("domain");
        writer.writeCharacters(s.getValue("domain", s.getDomain()));
        writer.writeEndElement();
        if (s.getDefaultPrincipal() != null) {
            writer.writeStartElement("default-principal");
            writer.writeCharacters(s.getValue("default-principal", s.getDefaultPrincipal()));
            writer.writeEndElement();
        }
        if (s.getDefaultGroups() != null && !s.getDefaultGroups().isEmpty()) {
            writer.writeStartElement("default-groups");
            for (int i = 0; i < s.getDefaultGroups().size(); ++i) {
                writer.writeStartElement("group");
                writer.writeCharacters(s.getValue("default-groups", Integer.toString(i), s.getDefaultGroups().get(i)));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (s.getUserMappings() != null && !s.getUserMappings().isEmpty() || s.getGroupMappings() != null && !s.getGroupMappings().isEmpty()) {
            writer.writeStartElement("mappings");
            if (s.getUserMappings() != null && !s.getUserMappings().isEmpty()) {
                writer.writeStartElement("users");
                for (Map.Entry<String, String> entry : s.getUserMappings().entrySet()) {
                    writer.writeStartElement("map");
                    writer.writeAttribute("from", s.getValue("users", entry.getKey(), entry.getKey()));
                    writer.writeAttribute("to", s.getValue("users", entry.getValue(), entry.getValue()));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (s.getGroupMappings() != null && !s.getGroupMappings().isEmpty()) {
                writer.writeStartElement("groups");
                for (Map.Entry<String, String> entry : s.getGroupMappings().entrySet()) {
                    writer.writeStartElement("map");
                    writer.writeAttribute("from", s.getValue("groups", entry.getKey(), entry.getKey()));
                    writer.writeAttribute("to", s.getValue("groups", entry.getValue(), entry.getValue()));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void storeConnectionDefinition(ConnectionDefinition cd, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("connection-definition");
        if (cd.getClassName() != null) {
            writer.writeAttribute("class-name", cd.getValue("class-name", cd.getClassName()));
        }
        if (cd.getJndiName() != null) {
            writer.writeAttribute("jndi-name", cd.getValue("jndi-name", cd.getJndiName()));
        }
        if (cd.isEnabled() != null && (cd.hasExpression("enabled") || !Defaults.ENABLED.equals(cd.isEnabled()))) {
            writer.writeAttribute("enabled", cd.getValue("enabled", cd.isEnabled().toString()));
        }
        if (cd.getId() != null) {
            writer.writeAttribute("id", cd.getValue("id", cd.getId()));
        }
        if (cd.isUseCcm() != null && (cd.hasExpression("use-ccm") || !Defaults.USE_CCM.equals(cd.isUseCcm()))) {
            writer.writeAttribute("use-ccm", cd.getValue("use-ccm", cd.isUseCcm().toString()));
        }
        if (cd.isSharable() != null && (cd.hasExpression("sharable") || !Defaults.SHARABLE.equals(cd.isSharable()))) {
            writer.writeAttribute("sharable", cd.getValue("sharable", cd.isSharable().toString()));
        }
        if (cd.isEnlistment() != null && (cd.hasExpression("enlistment") || !Defaults.ENLISTMENT.equals(cd.isEnlistment()))) {
            writer.writeAttribute("enlistment", cd.getValue("enlistment", cd.isEnlistment().toString()));
        }
        if (cd.isConnectable() != null && (cd.hasExpression("connectable") || !Defaults.CONNECTABLE.equals(cd.isConnectable()))) {
            writer.writeAttribute("connectable", cd.getValue("connectable", cd.isConnectable().toString()));
        }
        if (cd.isTracking() != null) {
            writer.writeAttribute("tracking", cd.getValue("tracking", cd.isTracking().toString()));
        }
        if (cd.getConfigProperties() != null && !cd.getConfigProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : cd.getConfigProperties().entrySet()) {
                writer.writeStartElement("config-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(cd.getValue("config-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        if (cd.getPool() != null) {
            if (cd.getPool() instanceof XaPool) {
                this.storeXaPool((XaPool)cd.getPool(), writer);
            } else {
                this.storePool(cd.getPool(), writer);
            }
        }
        if (cd.getSecurity() != null) {
            this.storeSecurity(cd.getSecurity(), writer);
        }
        if (cd.getTimeout() != null) {
            this.storeTimeout(cd.getTimeout(), writer);
        }
        if (cd.getValidation() != null) {
            this.storeValidation(cd.getValidation(), writer);
        }
        if (cd.getRecovery() != null) {
            this.storeRecovery(cd.getRecovery(), writer);
        }
        writer.writeEndElement();
    }

    protected void storeAdminObject(AdminObject ao, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("admin-object");
        if (ao.getClassName() != null) {
            writer.writeAttribute("class-name", ao.getValue("class-name", ao.getClassName()));
        }
        if (ao.getJndiName() != null) {
            writer.writeAttribute("jndi-name", ao.getValue("jndi-name", ao.getJndiName()));
        }
        if (ao.isEnabled() != null && (ao.hasExpression("enabled") || !Defaults.ENABLED.equals(ao.isEnabled()))) {
            writer.writeAttribute("enabled", ao.getValue("enabled", ao.isEnabled().toString()));
        }
        if (ao.getId() != null) {
            writer.writeAttribute("id", ao.getValue("id", ao.getId()));
        }
        if (ao.getConfigProperties() != null && !ao.getConfigProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : ao.getConfigProperties().entrySet()) {
                writer.writeStartElement("config-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(ao.getValue("config-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void storePool(Pool pool, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("pool");
        if (pool.getType() != null) {
            writer.writeAttribute("type", pool.getValue("type", pool.getType()));
        }
        if (pool.getJanitor() != null) {
            writer.writeAttribute("janitor", pool.getValue("janitor", pool.getJanitor()));
        }
        if (pool.getMinPoolSize() != null && (pool.hasExpression("min-pool-size") || !Defaults.MIN_POOL_SIZE.equals(pool.getMinPoolSize()))) {
            writer.writeStartElement("min-pool-size");
            writer.writeCharacters(pool.getValue("min-pool-size", pool.getMinPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getInitialPoolSize() != null) {
            writer.writeStartElement("initial-pool-size");
            writer.writeCharacters(pool.getValue("initial-pool-size", pool.getInitialPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getMaxPoolSize() != null && (pool.hasExpression("max-pool-size") || !Defaults.MAX_POOL_SIZE.equals(pool.getMaxPoolSize()))) {
            writer.writeStartElement("max-pool-size");
            writer.writeCharacters(pool.getValue("max-pool-size", pool.getMaxPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.isPrefill() != null && (pool.hasExpression("prefill") || !Defaults.PREFILL.equals(pool.isPrefill()))) {
            writer.writeStartElement("prefill");
            writer.writeCharacters(pool.getValue("prefill", pool.isPrefill().toString()));
            writer.writeEndElement();
        }
        if (pool.getFlushStrategy() != null && (pool.hasExpression("flush-strategy") || !Defaults.FLUSH_STRATEGY.equals((Object)pool.getFlushStrategy()))) {
            writer.writeStartElement("flush-strategy");
            writer.writeCharacters(pool.getValue("flush-strategy", pool.getFlushStrategy().toString()));
            writer.writeEndElement();
        }
        if (pool.getCapacity() != null) {
            this.storeCapacity(pool.getCapacity(), writer);
        }
        writer.writeEndElement();
    }

    protected void storeXaPool(XaPool pool, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("xa-pool");
        if (pool.getType() != null) {
            writer.writeAttribute("type", pool.getValue("type", pool.getType()));
        }
        if (pool.getType() != null) {
            writer.writeAttribute("janitor", pool.getValue("janitor", pool.getJanitor()));
        }
        if (pool.getMinPoolSize() != null && (pool.hasExpression("min-pool-size") || !Defaults.MIN_POOL_SIZE.equals(pool.getMinPoolSize()))) {
            writer.writeStartElement("min-pool-size");
            writer.writeCharacters(pool.getValue("min-pool-size", pool.getMinPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getInitialPoolSize() != null) {
            writer.writeStartElement("initial-pool-size");
            writer.writeCharacters(pool.getValue("initial-pool-size", pool.getInitialPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getMaxPoolSize() != null && (pool.hasExpression("max-pool-size") || !Defaults.MAX_POOL_SIZE.equals(pool.getMaxPoolSize()))) {
            writer.writeStartElement("max-pool-size");
            writer.writeCharacters(pool.getValue("max-pool-size", pool.getMaxPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.isPrefill() != null && (pool.hasExpression("prefill") || !Defaults.PREFILL.equals(pool.isPrefill()))) {
            writer.writeStartElement("prefill");
            writer.writeCharacters(pool.getValue("prefill", pool.isPrefill().toString()));
            writer.writeEndElement();
        }
        if (pool.getFlushStrategy() != null && (pool.hasExpression("flush-strategy") || !Defaults.FLUSH_STRATEGY.equals((Object)pool.getFlushStrategy()))) {
            writer.writeStartElement("flush-strategy");
            writer.writeCharacters(pool.getValue("flush-strategy", pool.getFlushStrategy().toString()));
            writer.writeEndElement();
        }
        if (pool.getCapacity() != null) {
            this.storeCapacity(pool.getCapacity(), writer);
        }
        if (pool.isIsSameRmOverride() != null) {
            writer.writeStartElement("is-same-rm-override");
            writer.writeCharacters(pool.getValue("is-same-rm-override", pool.isIsSameRmOverride().toString()));
            writer.writeEndElement();
        }
        if (pool.isPadXid() != null && (pool.hasExpression("pad-xid") || !Defaults.PAD_XID.equals(pool.isPadXid()))) {
            writer.writeStartElement("pad-xid");
            writer.writeCharacters(pool.getValue("pad-xid", pool.isPadXid().toString()));
            writer.writeEndElement();
        }
        if (pool.isWrapXaResource() != null && (pool.hasExpression("wrap-xa-resource") || !Defaults.WRAP_XA_RESOURCE.equals(pool.isWrapXaResource()))) {
            writer.writeStartElement("wrap-xa-resource");
            writer.writeCharacters(pool.getValue("wrap-xa-resource", pool.isWrapXaResource().toString()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeSecurity(Security s, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("security");
        if (s.getSecurityDomain() != null) {
            writer.writeStartElement("security-domain");
            writer.writeCharacters(s.getValue("security-domain", s.getSecurityDomain()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeValidation(Validation v, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("validation");
        if (v.isValidateOnMatch() != null) {
            writer.writeStartElement("validate-on-match");
            writer.writeCharacters(v.getValue("validate-on-match", v.isValidateOnMatch().toString()));
            writer.writeEndElement();
        }
        if (v.isBackgroundValidation() != null) {
            writer.writeStartElement("background-validation");
            writer.writeCharacters(v.getValue("background-validation", v.isBackgroundValidation().toString()));
            writer.writeEndElement();
        }
        if (v.getBackgroundValidationMillis() != null) {
            writer.writeStartElement("background-validation-millis");
            writer.writeCharacters(v.getValue("background-validation-millis", v.getBackgroundValidationMillis().toString()));
            writer.writeEndElement();
        }
        if (v.isUseFastFail() != null) {
            writer.writeStartElement("use-fast-fail");
            writer.writeCharacters(v.getValue("use-fast-fail", v.isUseFastFail().toString()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeTimeout(Timeout t, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("timeout");
        if (t.getBlockingTimeoutMillis() != null) {
            writer.writeStartElement("blocking-timeout-millis");
            writer.writeCharacters(t.getValue("blocking-timeout-millis", t.getBlockingTimeoutMillis().toString()));
            writer.writeEndElement();
        }
        if (t.getIdleTimeoutMinutes() != null) {
            writer.writeStartElement("idle-timeout-minutes");
            writer.writeCharacters(t.getValue("idle-timeout-minutes", t.getIdleTimeoutMinutes().toString()));
            writer.writeEndElement();
        }
        if (t.getAllocationRetry() != null) {
            writer.writeStartElement("allocation-retry");
            writer.writeCharacters(t.getValue("allocation-retry", t.getAllocationRetry().toString()));
            writer.writeEndElement();
        }
        if (t.getAllocationRetryWaitMillis() != null) {
            writer.writeStartElement("allocation-retry-wait-millis");
            writer.writeCharacters(t.getValue("allocation-retry-wait-millis", t.getAllocationRetryWaitMillis().toString()));
            writer.writeEndElement();
        }
        if (t.getXaResourceTimeout() != null) {
            writer.writeStartElement("xa-resource-timeout");
            writer.writeCharacters(t.getValue("xa-resource-timeout", t.getXaResourceTimeout().toString()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

