/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.common.metadata.common.Expression;
import org.ironjacamar.common.metadata.common.SecurityActions;
import org.ironjacamar.common.metadata.common.StringUtils;

public class ExpressionTemplate {
    private String text;
    private String template;
    private Map<String, Expression> entities;
    private boolean complex;

    public ExpressionTemplate(String expression) {
        this.text = expression;
        this.complex = false;
        this.entities = new HashMap<String, Expression>();
        this.parse();
    }

    private void parse() {
        this.template = this.text;
        if (StringUtils.isEmptyTrimmed(this.template)) {
            return;
        }
        int index = 0;
        while (this.template.indexOf("${") != -1) {
            int from = this.template.lastIndexOf("${");
            int to = this.template.indexOf("}", from + 2);
            if (to == -1) {
                this.template = this.text;
                this.complex = false;
                this.entities.clear();
                return;
            }
            int dv = this.template.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = null;
            String defaultValue = null;
            String s = this.template.substring(from + 2, to);
            if ("/".equals(s)) {
                systemProperty = File.separator;
            } else if (":".equals(s)) {
                systemProperty = File.pathSeparator;
                dv = -1;
            } else {
                systemProperty = SecurityActions.getSystemProperty(s);
            }
            if (dv != -1) {
                s = this.template.substring(from + 2, dv);
                systemProperty = SecurityActions.getSystemProperty(s);
                defaultValue = this.template.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            String key = StringUtils.createKey(index++);
            this.updateComplex(defaultValue);
            this.entities.put(key, new Expression(s, defaultValue, systemProperty));
            if (from != 0) {
                prefix = this.template.substring(0, from);
            }
            if (to + 1 < this.template.length()) {
                postfix = this.template.substring(to + 1);
            }
            this.template = prefix + key + postfix;
        }
        this.updateComplex(this.template);
    }

    private void updateComplex(String string) {
        if (string != null && StringUtils.getExpressionKey(string) != null && !string.equals(StringUtils.getExpressionKey(string))) {
            this.complex = true;
        }
    }

    public boolean isComplex() {
        return this.complex;
    }

    public String getText() {
        return this.text;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Expression> getEntities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public String getValue() {
        return this.resolveTemplate(true);
    }

    private String resolveTemplate(boolean toValue) {
        String key;
        String result = this.template;
        if (StringUtils.isEmptyTrimmed(result)) {
            return result;
        }
        while ((key = StringUtils.getExpressionKey(result)) != null) {
            String subs;
            Expression ex = this.entities.get(key);
            String nKey = StringUtils.getExpressionKey(ex.getDefaultValue());
            if (toValue) {
                subs = ex.getValue();
            } else if (nKey != null && ex.getResolvedValue() != null && ex.getDefaultValue().equals(nKey)) {
                this.entities.get(nKey).setResolvedValue(ex.getResolvedValue());
                subs = ex.toString();
            } else {
                subs = ex.toSubstitution();
            }
            result = result.replace(key, subs);
        }
        return result;
    }

    public String getSubstitution() {
        return this.resolveTemplate(false);
    }
}

