/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;
import org.jboss.logging.Messages;

public class ExtensionImpl
extends AbstractMetadata
implements Extension {
    private static final long serialVersionUID = -6275984008991105644L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private String className;
    private Map<String, String> configPropertiesMap;
    private String moduleName;
    private String moduleSlot;

    public ExtensionImpl(String className, String moduleName, String moduleSlot, Map<String, String> configPropertiesMap, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.className = className;
        if (configPropertiesMap != null) {
            this.configPropertiesMap = new HashMap<String, String>(configPropertiesMap.size());
            this.configPropertiesMap.putAll(configPropertiesMap);
        } else {
            this.configPropertiesMap = Collections.emptyMap();
        }
        this.moduleName = moduleName;
        this.moduleSlot = moduleSlot;
        this.validate();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Map<String, String> getConfigPropertiesMap() {
        return Collections.unmodifiableMap(this.configPropertiesMap);
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getModuleSlot() {
        return this.moduleSlot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configPropertiesMap == null ? 0 : this.configPropertiesMap.hashCode());
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.moduleSlot == null ? 0 : this.moduleSlot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionImpl)) {
            return false;
        }
        ExtensionImpl other = (ExtensionImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.configPropertiesMap == null ? other.configPropertiesMap != null : !this.configPropertiesMap.equals(other.configPropertiesMap)) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        return !(this.moduleSlot == null ? other.moduleSlot != null : !this.moduleSlot.equals(other.moduleSlot));
    }

    @Override
    public void validate() throws ValidateException {
        if (this.className == null || this.className.trim().length() == 0) {
            throw new ValidateException(bundle.missingClassName(this.getClass().getCanonicalName()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(" ").append("class-name").append("=\"");
        sb.append(this.getClassName()).append("\"");
        if (this.getModuleName() != null) {
            sb.append(" ").append("module-name").append("=\"");
            sb.append(this.getModuleName()).append("\"");
        }
        if (this.getModuleSlot() != null) {
            sb.append(" ").append("module-slot").append("=\"");
            sb.append(this.getModuleSlot()).append("\"");
        }
        sb.append(">");
        if (!this.getConfigPropertiesMap().isEmpty()) {
            for (Map.Entry<String, String> entry : this.getConfigPropertiesMap().entrySet()) {
                sb.append("<").append("config-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("config-property").append(">");
            }
        }
        return sb.toString();
    }
}

