/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Capacity;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.common.api.metadata.common.Pool;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;
import org.jboss.logging.Messages;

public class PoolImpl
extends AbstractMetadata
implements Pool {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected String type;
    protected String janitor;
    protected Integer minPoolSize;
    protected Integer initialPoolSize;
    protected Integer maxPoolSize;
    protected Boolean prefill;
    protected FlushStrategy flushStrategy;
    protected Capacity capacity;

    public PoolImpl(String type, String janitor, Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, FlushStrategy flushStrategy, Capacity capacity, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.type = type;
        this.janitor = janitor;
        this.minPoolSize = minPoolSize;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.prefill = prefill;
        this.flushStrategy = flushStrategy;
        this.capacity = capacity;
        this.validate();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getJanitor() {
        return this.janitor;
    }

    @Override
    public Integer getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public Boolean isPrefill() {
        return this.prefill;
    }

    @Override
    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    @Override
    public Capacity getCapacity() {
        return this.capacity;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.maxPoolSize != null && this.maxPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative("max-pool-size"));
        }
        if (this.minPoolSize != null && this.minPoolSize < 0) {
            throw new ValidateException(bundle.invalidNegative("min-pool-size"));
        }
        if (this.minPoolSize != null && this.maxPoolSize != null && this.minPoolSize > this.maxPoolSize) {
            throw new ValidateException(bundle.notValidNumber(this.minPoolSize.toString(), "min-pool-size"));
        }
        if (this.flushStrategy == null) {
            throw new ValidateException(bundle.nullValue("flush-strategy"));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.janitor == null ? 0 : this.janitor.hashCode());
        result = 31 * result + (this.minPoolSize == null ? 0 : this.minPoolSize.hashCode());
        result = 31 * result + (this.initialPoolSize == null ? 0 : this.initialPoolSize.hashCode());
        result = 31 * result + (this.maxPoolSize == null ? 0 : this.maxPoolSize.hashCode());
        result = 31 * result + (this.prefill == null ? 0 : this.prefill.hashCode());
        result = 31 * result + (this.flushStrategy == null ? 0 : this.flushStrategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolImpl)) {
            return false;
        }
        PoolImpl other = (PoolImpl)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.janitor == null ? other.janitor != null : !this.janitor.equals(other.janitor)) {
            return false;
        }
        if (this.minPoolSize == null ? other.minPoolSize != null : !this.minPoolSize.equals(other.minPoolSize)) {
            return false;
        }
        if (this.initialPoolSize == null ? other.initialPoolSize != null : !this.initialPoolSize.equals(other.initialPoolSize)) {
            return false;
        }
        if (this.maxPoolSize == null ? other.maxPoolSize != null : !this.maxPoolSize.equals(other.maxPoolSize)) {
            return false;
        }
        if (this.prefill == null ? other.prefill != null : !this.prefill.equals(other.prefill)) {
            return false;
        }
        if (this.flushStrategy == null ? other.flushStrategy != null : !this.flushStrategy.equals((Object)other.flushStrategy)) {
            return false;
        }
        return !(this.capacity == null ? other.capacity != null : !this.capacity.equals(other.capacity));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool");
        if (this.type != null) {
            sb.append(" ").append("type").append("=\"");
            sb.append(this.type);
            sb.append("\"");
        }
        if (this.type != null) {
            sb.append(" ").append("janitor").append("=\"");
            sb.append(this.janitor);
            sb.append("\"");
        }
        sb.append(">");
        if (this.minPoolSize != null && !Defaults.MIN_POOL_SIZE.equals(this.minPoolSize)) {
            sb.append("<").append("min-pool-size").append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append("min-pool-size").append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append("initial-pool-size").append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append("initial-pool-size").append(">");
        }
        if (this.maxPoolSize != null && !Defaults.MAX_POOL_SIZE.equals(this.maxPoolSize)) {
            sb.append("<").append("max-pool-size").append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append("max-pool-size").append(">");
        }
        if (this.prefill != null && !Defaults.PREFILL.equals(this.prefill)) {
            sb.append("<").append("prefill").append(">");
            sb.append(this.prefill);
            sb.append("</").append("prefill").append(">");
        }
        if (this.flushStrategy != null && !Defaults.FLUSH_STRATEGY.equals((Object)this.flushStrategy)) {
            sb.append("<").append("flush-strategy").append(">");
            sb.append((Object)this.flushStrategy);
            sb.append("</").append("flush-strategy").append(">");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

