/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Map;
import org.ironjacamar.common.api.metadata.common.Credential;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class RecoveryImpl
extends AbstractMetadata
implements Recovery {
    private static final long serialVersionUID = -7425365995463321893L;
    private Credential credential;
    protected Extension plugin;
    protected Boolean noRecovery;

    public RecoveryImpl(Credential credential, Extension plugin, Boolean noRecovery, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.credential = credential;
        this.plugin = plugin;
        this.noRecovery = noRecovery;
        this.validate();
    }

    @Override
    public Credential getCredential() {
        return this.credential;
    }

    @Override
    public Extension getPlugin() {
        return this.plugin;
    }

    @Override
    public Boolean isNoRecovery() {
        return this.noRecovery;
    }

    @Override
    public void validate() throws ValidateException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.noRecovery == null ? 0 : this.noRecovery.hashCode());
        result = 31 * result + (this.plugin == null ? 0 : this.plugin.hashCode());
        result = 31 * result + (this.credential == null ? 0 : this.credential.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryImpl)) {
            return false;
        }
        RecoveryImpl other = (RecoveryImpl)obj;
        if (this.noRecovery == null ? other.noRecovery != null : !this.noRecovery.equals(other.noRecovery)) {
            return false;
        }
        if (this.plugin == null ? other.plugin != null : !this.plugin.equals(other.plugin)) {
            return false;
        }
        return !(this.credential == null ? other.credential != null : !this.credential.equals(other.credential));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<recovery");
        if (this.noRecovery != null) {
            sb.append(" ").append("no-recovery").append("=\"").append(this.noRecovery).append("\"");
        }
        sb.append(">");
        if (this.credential != null) {
            sb.append("<").append("recovery-credential").append(">");
            sb.append("<").append("security-domain").append(">");
            sb.append(this.credential.getSecurityDomain());
            sb.append("</").append("security-domain").append(">");
            sb.append("</").append("recovery-credential").append(">");
        }
        if (this.plugin != null) {
            sb.append("<").append("recovery-plugin");
            sb.append(this.plugin.toString());
            sb.append("</").append("recovery-plugin").append(">");
        }
        sb.append("</recovery>");
        return sb.toString();
    }
}

