/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Map;
import org.ironjacamar.common.metadata.common.ExpressionTemplate;

public class StringUtils {
    private static String startTag = ">?&%<";
    private static String endTag = "<%&?>";

    public static String restoreExpression(Map<String, String> m, String key, String subkey, String v) {
        String k = key;
        if (subkey != null) {
            if (!StringUtils.isIncorrectExpression(subkey) && subkey.startsWith("${") && (subkey = subkey.substring(2, subkey.length() - 1)).indexOf(":") != -1) {
                subkey = subkey.substring(0, subkey.indexOf(":"));
            }
            k = k + "|" + subkey;
        }
        return StringUtils.substituteValueInExpression(m.get(k), v);
    }

    public static String substituteValueInExpression(String expression, String newValue) {
        ExpressionTemplate t = new ExpressionTemplate(expression);
        if (newValue != null && (StringUtils.getExpressionKey(t.getTemplate()) == null || t.isComplex() && !newValue.equals(t.getValue()))) {
            return newValue;
        }
        String result = t.getSubstitution();
        if (!t.isComplex() && newValue != null) {
            int start = result.lastIndexOf(":$");
            start = result.indexOf(":", start + 1);
            int end = result.indexOf("}", start + 1);
            if (start < 0 || end < 0 || start == result.lastIndexOf("${:}") + 2) {
                return result;
            }
            result = result.substring(0, start + 1) + newValue + result.substring(end);
        }
        return result;
    }

    public static boolean isIncorrectExpression(String ex) {
        return StringUtils.isEmptyTrimmed(ex) || ex.equals(StringUtils.transformExpression(ex));
    }

    public static String transformExpression(String toTransform) {
        return new ExpressionTemplate(toTransform).getValue();
    }

    public static boolean isEmptyTrimmed(String input) {
        return input == null || input.trim().equals("");
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static String getExpressionKey(String result) {
        if (result == null) {
            return null;
        }
        try {
            int from = result.indexOf(startTag);
            int to = result.indexOf(endTag, from);
            Integer.parseInt(result.substring(from + 5, to));
            return result.substring(from, to + 5);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createKey(int index) {
        return startTag + index + endTag;
    }
}

