/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;
import org.jboss.logging.Messages;

public class TimeoutImpl
extends AbstractMetadata
implements Timeout {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected Long blockingTimeoutMillis;
    protected Integer idleTimeoutMinutes;
    protected Integer allocationRetry;
    protected Long allocationRetryWaitMillis;
    protected Integer xaResourceTimeout;

    public TimeoutImpl(Long blockingTimeoutMillis, Integer idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.blockingTimeoutMillis = blockingTimeoutMillis;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
        this.allocationRetry = allocationRetry;
        this.allocationRetryWaitMillis = allocationRetryWaitMillis;
        this.xaResourceTimeout = xaResourceTimeout;
        this.partialCommonValidate();
    }

    @Override
    public Long getBlockingTimeoutMillis() {
        return this.blockingTimeoutMillis;
    }

    @Override
    public Integer getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    @Override
    public Integer getAllocationRetry() {
        return this.allocationRetry;
    }

    @Override
    public Long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    @Override
    public Integer getXaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    private void partialCommonValidate() throws ValidateException {
        if (this.allocationRetry != null && this.allocationRetry < 0) {
            throw new ValidateException(bundle.invalidNegative("allocation-retry"));
        }
        if (this.blockingTimeoutMillis != null && this.blockingTimeoutMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative("blocking-timeout-millis"));
        }
        if (this.allocationRetryWaitMillis != null && this.allocationRetryWaitMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative("allocation-retry-wait-millis"));
        }
        if (this.idleTimeoutMinutes != null && this.idleTimeoutMinutes < 0) {
            throw new ValidateException(bundle.invalidNegative("idle-timeout-minutes"));
        }
        if (this.xaResourceTimeout != null && this.xaResourceTimeout < 0) {
            throw new ValidateException(bundle.invalidNegative("xa-resource-timeout"));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allocationRetry == null ? 0 : this.allocationRetry.hashCode());
        result = 31 * result + (this.allocationRetryWaitMillis == null ? 0 : this.allocationRetryWaitMillis.hashCode());
        result = 31 * result + (this.blockingTimeoutMillis == null ? 0 : this.blockingTimeoutMillis.hashCode());
        result = 31 * result + (this.idleTimeoutMinutes == null ? 0 : this.idleTimeoutMinutes.hashCode());
        result = 31 * result + (this.xaResourceTimeout == null ? 0 : this.xaResourceTimeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutImpl)) {
            return false;
        }
        TimeoutImpl other = (TimeoutImpl)obj;
        if (this.allocationRetry == null ? other.allocationRetry != null : !this.allocationRetry.equals(other.allocationRetry)) {
            return false;
        }
        if (this.allocationRetryWaitMillis == null ? other.allocationRetryWaitMillis != null : !this.allocationRetryWaitMillis.equals(other.allocationRetryWaitMillis)) {
            return false;
        }
        if (this.blockingTimeoutMillis == null ? other.blockingTimeoutMillis != null : !this.blockingTimeoutMillis.equals(other.blockingTimeoutMillis)) {
            return false;
        }
        if (this.idleTimeoutMinutes == null ? other.idleTimeoutMinutes != null : !this.idleTimeoutMinutes.equals(other.idleTimeoutMinutes)) {
            return false;
        }
        return !(this.xaResourceTimeout == null ? other.xaResourceTimeout != null : !this.xaResourceTimeout.equals(other.xaResourceTimeout));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<timeout>");
        if (this.blockingTimeoutMillis != null) {
            sb.append("<").append("blocking-timeout-millis").append(">");
            sb.append(this.blockingTimeoutMillis);
            sb.append("</").append("blocking-timeout-millis").append(">");
        }
        if (this.idleTimeoutMinutes != null) {
            sb.append("<").append("idle-timeout-minutes").append(">");
            sb.append(this.idleTimeoutMinutes);
            sb.append("</").append("idle-timeout-minutes").append(">");
        }
        if (this.allocationRetry != null) {
            sb.append("<").append("allocation-retry").append(">");
            sb.append(this.allocationRetry);
            sb.append("</").append("allocation-retry").append(">");
        }
        if (this.allocationRetryWaitMillis != null) {
            sb.append("<").append("allocation-retry-wait-millis").append(">");
            sb.append(this.allocationRetryWaitMillis);
            sb.append("</").append("allocation-retry-wait-millis").append(">");
        }
        if (this.xaResourceTimeout != null) {
            sb.append("<").append("xa-resource-timeout").append(">");
            sb.append(this.xaResourceTimeout);
            sb.append("</").append("xa-resource-timeout").append(">");
        }
        sb.append("</timeout>");
        return sb.toString();
    }
}

