/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.common;

import java.util.Map;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Capacity;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.common.api.metadata.common.XaPool;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.PoolImpl;

public class XaPoolImpl
extends PoolImpl
implements XaPool {
    private static final long serialVersionUID = 1L;
    protected Boolean isSameRmOverride;
    protected Boolean padXid;
    protected Boolean wrapXaResource;

    public XaPoolImpl(String type, String janitor, Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, FlushStrategy flushStrategy, Capacity capacity, Boolean isSameRmOverride, Boolean padXid, Boolean wrapXaResource, Map<String, String> expressions) throws ValidateException {
        super(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, capacity, expressions);
        this.isSameRmOverride = isSameRmOverride;
        this.padXid = padXid;
        this.wrapXaResource = wrapXaResource;
    }

    @Override
    public Boolean isIsSameRmOverride() {
        return this.isSameRmOverride;
    }

    @Override
    public Boolean isPadXid() {
        return this.padXid;
    }

    @Override
    public Boolean isWrapXaResource() {
        return this.wrapXaResource;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isSameRmOverride == null ? 0 : this.isSameRmOverride.hashCode());
        result = 31 * result + (this.padXid == null ? 0 : this.padXid.hashCode());
        result = 31 * result + (this.wrapXaResource == null ? 0 : this.wrapXaResource.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XaPoolImpl)) {
            return false;
        }
        XaPoolImpl other = (XaPoolImpl)obj;
        if (this.isSameRmOverride == null ? other.isSameRmOverride != null : !this.isSameRmOverride.equals(other.isSameRmOverride)) {
            return false;
        }
        if (this.padXid == null ? other.padXid != null : !this.padXid.equals(other.padXid)) {
            return false;
        }
        return !(this.wrapXaResource == null ? other.wrapXaResource != null : !this.wrapXaResource.equals(other.wrapXaResource));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool");
        if (this.type != null) {
            sb.append(" ").append("type").append("=\"");
            sb.append(this.type);
            sb.append("\"");
        }
        if (this.type != null) {
            sb.append(" ").append("janitor").append("=\"");
            sb.append(this.janitor);
            sb.append("\"");
        }
        sb.append(">");
        if (this.minPoolSize != null && !Defaults.MIN_POOL_SIZE.equals(this.minPoolSize)) {
            sb.append("<").append("min-pool-size").append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append("min-pool-size").append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append("initial-pool-size").append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append("initial-pool-size").append(">");
        }
        if (this.maxPoolSize != null && !Defaults.MAX_POOL_SIZE.equals(this.maxPoolSize)) {
            sb.append("<").append("max-pool-size").append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append("max-pool-size").append(">");
        }
        if (this.prefill != null && !Defaults.PREFILL.equals(this.prefill)) {
            sb.append("<").append("prefill").append(">");
            sb.append(this.prefill);
            sb.append("</").append("prefill").append(">");
        }
        if (this.flushStrategy != null && !Defaults.FLUSH_STRATEGY.equals((Object)this.flushStrategy)) {
            sb.append("<").append("flush-strategy").append(">");
            sb.append((Object)this.flushStrategy);
            sb.append("</").append("flush-strategy").append(">");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append("is-same-rm-override").append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append("is-same-rm-override").append(">");
        }
        if (this.padXid != null && !Defaults.PAD_XID.equals(this.padXid)) {
            sb.append("<").append("pad-xid").append(">");
            sb.append(this.padXid);
            sb.append("</").append("pad-xid").append(">");
        }
        if (this.wrapXaResource != null && !Defaults.WRAP_XA_RESOURCE.equals(this.wrapXaResource)) {
            sb.append("<").append("wrap-xa-resource").append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append("wrap-xa-resource").append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }
}

