/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.ds.CommonDataSource;
import org.ironjacamar.common.api.metadata.ds.DsSecurity;
import org.ironjacamar.common.api.metadata.ds.Statement;
import org.ironjacamar.common.api.metadata.ds.Timeout;
import org.ironjacamar.common.api.metadata.ds.TransactionIsolation;
import org.ironjacamar.common.api.metadata.ds.Validation;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;
import org.jboss.logging.Messages;

public abstract class DataSourceAbstractImpl
extends AbstractMetadata
implements CommonDataSource {
    private static final long serialVersionUID = -5612846950298960159L;
    protected static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected TransactionIsolation transactionIsolation;
    protected Timeout timeout;
    protected DsSecurity security;
    protected Statement statement;
    protected Validation validation;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClassName;
    protected String id;
    protected Boolean enabled;
    protected String jndiName;
    protected Boolean spy;
    protected Boolean useCcm;
    protected String driver;
    protected String newConnectionSql;
    protected Boolean connectable;
    protected Boolean tracking;

    protected DataSourceAbstractImpl(TransactionIsolation transactionIsolation, Timeout timeout, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String id, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, String driver, String newConnectionSql, Boolean connectable, Boolean tracking, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.transactionIsolation = transactionIsolation;
        this.timeout = timeout;
        this.security = security;
        this.statement = statement;
        this.validation = validation;
        this.urlDelimiter = urlDelimiter;
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
        this.id = id;
        this.enabled = enabled;
        this.jndiName = jndiName;
        this.spy = spy;
        this.useCcm = useCcm;
        this.driver = driver;
        this.newConnectionSql = newConnectionSql;
        this.connectable = connectable;
        this.tracking = tracking;
        this.partialCommonValidation();
    }

    @Override
    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public Timeout getTimeout() {
        return this.timeout;
    }

    @Override
    public DsSecurity getSecurity() {
        return this.security;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Boolean isSpy() {
        return this.spy;
    }

    @Override
    public Boolean isUseCcm() {
        return this.useCcm;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    public String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public Boolean isConnectable() {
        return this.connectable;
    }

    public Boolean isTracking() {
        return this.tracking;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    protected void partialCommonValidation() throws ValidateException {
        if (this.jndiName == null) {
            throw new ValidateException(bundle.requiredAttributeMissing("jndi-name", this.getClass().getCanonicalName()));
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
        if (this.security != null) {
            this.security.validate();
        }
        if (this.statement != null) {
            this.statement.validate();
        }
        if (this.validation != null) {
            this.validation.validate();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
        result = 31 * result + (this.timeout == null ? 0 : this.timeout.hashCode());
        result = 31 * result + (this.transactionIsolation == null ? 0 : this.transactionIsolation.hashCode());
        result = 31 * result + (this.urlDelimiter == null ? 0 : this.urlDelimiter.hashCode());
        result = 31 * result + (this.urlSelectorStrategyClassName == null ? 0 : this.urlSelectorStrategyClassName.hashCode());
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
        result = 31 * result + (this.tracking == null ? 0 : this.tracking.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceAbstractImpl)) {
            return false;
        }
        DataSourceAbstractImpl other = (DataSourceAbstractImpl)obj;
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.statement == null ? other.statement != null : !this.statement.equals(other.statement)) {
            return false;
        }
        if (this.timeout == null ? other.timeout != null : !this.timeout.equals(other.timeout)) {
            return false;
        }
        if (this.transactionIsolation != other.transactionIsolation) {
            return false;
        }
        if (this.urlDelimiter == null ? other.urlDelimiter != null : !this.urlDelimiter.equals(other.urlDelimiter)) {
            return false;
        }
        if (this.urlSelectorStrategyClassName == null ? other.urlSelectorStrategyClassName != null : !this.urlSelectorStrategyClassName.equals(other.urlSelectorStrategyClassName)) {
            return false;
        }
        if (this.validation == null ? other.validation != null : !this.validation.equals(other.validation)) {
            return false;
        }
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
            return false;
        }
        return !(this.tracking == null ? other.tracking != null : !this.tracking.equals(other.tracking));
    }

    public abstract String toString();
}

