/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.ds.DataSource;
import org.ironjacamar.common.api.metadata.ds.DsPool;
import org.ironjacamar.common.api.metadata.ds.DsSecurity;
import org.ironjacamar.common.api.metadata.ds.Statement;
import org.ironjacamar.common.api.metadata.ds.Timeout;
import org.ironjacamar.common.api.metadata.ds.TransactionIsolation;
import org.ironjacamar.common.api.metadata.ds.Validation;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.ds.DataSourceAbstractImpl;

public class DataSourceImpl
extends DataSourceAbstractImpl
implements DataSource {
    private static final long serialVersionUID = 1L;
    private Boolean jta;
    private String connectionUrl;
    private String driverClass;
    private String dataSourceClass;
    private Map<String, String> connectionProperties;
    private DsPool pool;

    public DataSourceImpl(String connectionUrl, String driverClass, String dataSourceClass, String driver, TransactionIsolation transactionIsolation, Map<String, String> connectionProperties, Timeout timeout, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, String newConnectionSql, String id, Boolean enabled, String jndiName, Boolean spy, Boolean useccm, Boolean jta, Boolean connectable, Boolean tracking, DsPool pool, Map<String, String> expressions) throws ValidateException {
        super(transactionIsolation, timeout, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, id, enabled, jndiName, spy, useccm, driver, newConnectionSql, connectable, tracking, expressions);
        this.jta = jta;
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        this.dataSourceClass = dataSourceClass;
        if (connectionProperties != null) {
            this.connectionProperties = new HashMap<String, String>(connectionProperties.size());
            this.connectionProperties.putAll(connectionProperties);
        } else {
            this.connectionProperties = new HashMap<String, String>(0);
        }
        this.pool = pool;
        this.validate();
    }

    @Override
    public Boolean isJTA() {
        return this.jta;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDriverClass() {
        return this.driverClass;
    }

    @Override
    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    @Override
    public Map<String, String> getConnectionProperties() {
        return Collections.unmodifiableMap(this.connectionProperties);
    }

    @Override
    public DsPool getPool() {
        return this.pool;
    }

    public void forceDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void forceDataSourceClass(String dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.driverClass != null && (this.connectionUrl == null || this.connectionUrl.trim().length() == 0)) {
            throw new ValidateException(bundle.requiredElementMissing("connection-url", this.getClass().getCanonicalName()));
        }
        if (!(this.driverClass != null && this.driverClass.trim().length() != 0 || this.dataSourceClass != null && this.dataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing("driver-class", this.getClass().getCanonicalName()));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.jta == null ? 0 : this.jta.hashCode());
        result = 31 * result + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.dataSourceClass == null ? 0 : this.dataSourceClass.hashCode());
        result = 31 * result + (this.connectionProperties == null ? 0 : this.connectionProperties.hashCode());
        result = 31 * result + (this.pool == null ? 0 : this.pool.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl other = (DataSourceImpl)obj;
        if (this.jta == null ? other.jta != null : !this.jta.equals(other.jta)) {
            return false;
        }
        if (this.connectionUrl == null ? other.connectionUrl != null : !this.connectionUrl.equals(other.connectionUrl)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.dataSourceClass == null ? other.dataSourceClass != null : !this.dataSourceClass.equals(other.dataSourceClass)) {
            return false;
        }
        if (this.connectionProperties == null ? other.connectionProperties != null : !this.connectionProperties.equals(other.connectionProperties)) {
            return false;
        }
        return !(this.pool == null ? other.pool != null : !this.pool.equals(other.pool));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<datasource");
        if (this.jta != null && !Defaults.JTA.equals(this.jta)) {
            sb.append(" ").append("jta").append("=\"").append(this.jta).append("\"");
        }
        if (this.jndiName != null) {
            sb.append(" ").append("jndi-name").append("=\"").append(this.jndiName).append("\"");
        }
        if (this.id != null) {
            sb.append(" ").append("id").append("=\"").append(this.id).append("\"");
        }
        if (this.enabled != null && !Defaults.ENABLED.equals(this.enabled)) {
            sb.append(" ").append("enabled").append("=\"").append(this.enabled).append("\"");
        }
        if (this.spy != null && !Defaults.SPY.equals(this.spy)) {
            sb.append(" ").append("spy").append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null && !Defaults.USE_CCM.equals(this.useCcm)) {
            sb.append(" ").append("use-ccm").append("=\"").append(this.useCcm).append("\"");
        }
        if (this.connectable != null && !Defaults.CONNECTABLE.equals(this.connectable)) {
            sb.append(" ").append("connectable").append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append("tracking").append("=\"").append(this.tracking).append("\"");
        }
        sb.append(">");
        if (this.connectionUrl != null) {
            sb.append("<").append("connection-url").append(">");
            sb.append(this.connectionUrl);
            sb.append("</").append("connection-url").append(">");
        }
        if (this.driverClass != null) {
            sb.append("<").append("driver-class").append(">");
            sb.append(this.driverClass);
            sb.append("</").append("driver-class").append(">");
        }
        if (this.dataSourceClass != null) {
            sb.append("<").append("datasource-class").append(">");
            sb.append(this.dataSourceClass);
            sb.append("</").append("datasource-class").append(">");
        }
        if (this.driver != null) {
            sb.append("<").append("driver").append(">");
            sb.append(this.driver);
            sb.append("</").append("driver").append(">");
        }
        if (this.connectionProperties != null && !this.connectionProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
                sb.append("<").append("connection-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("connection-property").append(">");
            }
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append("new-connection-sql").append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append("new-connection-sql").append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append("transaction-isolation").append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append("transaction-isolation").append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append("url-delimiter").append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append("url-delimiter").append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append("url-selector-strategy-class-name").append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append("url-selector-strategy-class-name").append(">");
        }
        if (this.pool != null) {
            sb.append(this.pool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeout != null) {
            sb.append(this.timeout);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        sb.append("</datasource>");
        return sb.toString();
    }
}

