/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ironjacamar.common.api.metadata.ds.DataSource;
import org.ironjacamar.common.api.metadata.ds.DataSources;
import org.ironjacamar.common.api.metadata.ds.Driver;
import org.ironjacamar.common.api.metadata.ds.XaDataSource;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;

public class DatasourcesImpl
extends AbstractMetadata
implements DataSources {
    private static final long serialVersionUID = 6933310057105771370L;
    private final List<DataSource> datasource;
    private final List<XaDataSource> xaDataSource;
    private final Map<String, Driver> drivers;

    public DatasourcesImpl(List<DataSource> datasource, List<XaDataSource> xaDataSource, Map<String, Driver> drivers) throws ValidateException {
        super(null);
        if (datasource != null) {
            this.datasource = new ArrayList<DataSource>(datasource.size());
            this.datasource.addAll(datasource);
        } else {
            this.datasource = new ArrayList<DataSource>(0);
        }
        if (xaDataSource != null) {
            this.xaDataSource = new ArrayList<XaDataSource>(xaDataSource.size());
            this.xaDataSource.addAll(xaDataSource);
        } else {
            this.xaDataSource = new ArrayList<XaDataSource>(0);
        }
        if (drivers != null) {
            this.drivers = new HashMap<String, Driver>(drivers.size());
            this.drivers.putAll(drivers);
        } else {
            this.drivers = new HashMap<String, Driver>(0);
        }
        this.validate();
    }

    @Override
    public final List<DataSource> getDataSource() {
        return Collections.unmodifiableList(this.datasource);
    }

    @Override
    public final List<XaDataSource> getXaDataSource() {
        return Collections.unmodifiableList(this.xaDataSource);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datasource == null ? 0 : this.datasource.hashCode());
        result = 31 * result + (this.xaDataSource == null ? 0 : this.xaDataSource.hashCode());
        result = 31 * result + (this.drivers == null ? 0 : this.drivers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcesImpl)) {
            return false;
        }
        DatasourcesImpl other = (DatasourcesImpl)obj;
        if (this.datasource == null ? other.datasource != null : !this.datasource.equals(other.datasource)) {
            return false;
        }
        if (this.xaDataSource == null ? other.xaDataSource != null : !this.xaDataSource.equals(other.xaDataSource)) {
            return false;
        }
        return !(this.drivers == null ? other.drivers != null : !this.drivers.equals(other.drivers));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<datasources>");
        if (this.datasource != null && !this.datasource.isEmpty()) {
            for (DataSource ds : this.datasource) {
                sb.append(ds);
            }
        }
        if (this.xaDataSource != null && !this.xaDataSource.isEmpty()) {
            for (XaDataSource xads : this.xaDataSource) {
                sb.append(xads);
            }
        }
        if (this.drivers != null && !this.drivers.isEmpty()) {
            sb.append("<").append("drivers").append(">");
            for (Driver d : this.drivers.values()) {
                sb.append(d);
            }
            sb.append("</").append("drivers").append(">");
        }
        sb.append("</datasources>");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidateException {
        for (DataSource ds : this.datasource) {
            ds.validate();
        }
        for (XaDataSource xads : this.xaDataSource) {
            xads.validate();
        }
    }

    @Override
    public Driver getDriver(String name) {
        return this.drivers.get(name);
    }

    @Override
    public List<Driver> getDrivers() {
        return Collections.unmodifiableList(new ArrayList<Driver>(this.drivers.values()));
    }
}

