/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Capacity;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.metadata.ds.Credential;
import org.ironjacamar.common.api.metadata.ds.DataSource;
import org.ironjacamar.common.api.metadata.ds.DataSources;
import org.ironjacamar.common.api.metadata.ds.Driver;
import org.ironjacamar.common.api.metadata.ds.DsPool;
import org.ironjacamar.common.api.metadata.ds.DsSecurity;
import org.ironjacamar.common.api.metadata.ds.DsXaPool;
import org.ironjacamar.common.api.metadata.ds.Statement;
import org.ironjacamar.common.api.metadata.ds.Timeout;
import org.ironjacamar.common.api.metadata.ds.TransactionIsolation;
import org.ironjacamar.common.api.metadata.ds.Validation;
import org.ironjacamar.common.api.metadata.ds.XaDataSource;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.MetadataParser;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.AbstractParser;
import org.ironjacamar.common.metadata.ds.CredentialImpl;
import org.ironjacamar.common.metadata.ds.DataSourceImpl;
import org.ironjacamar.common.metadata.ds.DatasourcesImpl;
import org.ironjacamar.common.metadata.ds.DriverImpl;
import org.ironjacamar.common.metadata.ds.DsPoolImpl;
import org.ironjacamar.common.metadata.ds.DsSecurityImpl;
import org.ironjacamar.common.metadata.ds.DsXaPoolImpl;
import org.ironjacamar.common.metadata.ds.RecoveryImpl;
import org.ironjacamar.common.metadata.ds.StatementImpl;
import org.ironjacamar.common.metadata.ds.TimeoutImpl;
import org.ironjacamar.common.metadata.ds.ValidationImpl;
import org.ironjacamar.common.metadata.ds.XADataSourceImpl;

public class DsParser
extends AbstractParser
implements MetadataParser<DataSources> {
    @Override
    public DataSources parse(XMLStreamReader reader) throws Exception {
        int iterate;
        DataSources dataSources = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (reader.getLocalName()) {
                    case "datasources": {
                        dataSources = this.parseDataSources(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dataSources;
    }

    @Override
    public void store(DataSources metadata, XMLStreamWriter writer) throws Exception {
        if (metadata != null && writer != null) {
            writer.writeStartElement("datasources");
            if (metadata.getDataSource() != null && !metadata.getDataSource().isEmpty()) {
                for (DataSource ds : metadata.getDataSource()) {
                    this.storeDataSource(ds, writer);
                }
            }
            if (metadata.getXaDataSource() != null && !metadata.getXaDataSource().isEmpty()) {
                for (XaDataSource xads : metadata.getXaDataSource()) {
                    this.storeXaDataSource(xads, writer);
                }
            }
            if (metadata.getDrivers() != null && !metadata.getDrivers().isEmpty()) {
                writer.writeStartElement("drivers");
                for (Driver drv : metadata.getDrivers()) {
                    this.storeDriver(drv, writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected DataSources parseDataSources(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<DataSource> datasource = new ArrayList<DataSource>();
        ArrayList<XaDataSource> xaDataSource = new ArrayList<XaDataSource>();
        HashMap<String, Driver> drivers = new HashMap<String, Driver>();
        boolean driversMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("datasources".equals(reader.getLocalName())) {
                        return new DatasourcesImpl(datasource, xaDataSource, drivers);
                    }
                    switch (reader.getLocalName()) {
                        case "datasource": 
                        case "xa-datasource": 
                        case "drivers": 
                        case "driver": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "datasource": {
                            datasource.add(this.parseDataSource(reader));
                            break block0;
                        }
                        case "xa-datasource": {
                            xaDataSource.add(this.parseXADataSource(reader));
                            break block0;
                        }
                        case "drivers": {
                            driversMatched = true;
                            break block0;
                        }
                        case "driver": {
                            Driver driver = this.parseDriver(reader);
                            drivers.put(driver.getName(), driver);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Driver parseDriver(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String driverClass = null;
        String dataSourceClass = null;
        String xaDataSourceClass = null;
        String name = null;
        Integer majorVersion = null;
        Integer minorVersion = null;
        String module = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block34: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = this.attributeAsString(reader, "name", expressions);
                    continue block34;
                }
                case "major-version": {
                    majorVersion = this.attributeAsInt(reader, "major-version", expressions);
                    continue block34;
                }
                case "minor-version": {
                    minorVersion = this.attributeAsInt(reader, "minor-version", expressions);
                    continue block34;
                }
                case "module": {
                    module = this.attributeAsString(reader, "module", expressions);
                    continue block34;
                }
            }
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if ("driver".equals(reader.getLocalName())) {
                        return new DriverImpl(name, majorVersion, minorVersion, module, driverClass, dataSourceClass, xaDataSourceClass, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "datasource-class": 
                        case "xa-datasource-class": 
                        case "driver-class": {
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "datasource-class": {
                            dataSourceClass = this.elementAsString(reader, "datasource-class", expressions);
                            break block12;
                        }
                        case "xa-datasource-class": {
                            xaDataSourceClass = this.elementAsString(reader, "xa-datasource-class", expressions);
                            break block12;
                        }
                        case "driver-class": {
                            driverClass = this.elementAsString(reader, "driver-class", expressions);
                            break block12;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        Extension reauthPlugin = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("security".equals(reader.getLocalName())) {
                        return new DsSecurityImpl(userName, password, securityDomain, reauthPlugin, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "password": 
                        case "user-name": 
                        case "security-domain": 
                        case "reauth-plugin": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "password": {
                            password = this.elementAsString(reader, "password", expressions);
                            break block0;
                        }
                        case "user-name": {
                            userName = this.elementAsString(reader, "user-name", expressions);
                            break block0;
                        }
                        case "security-domain": {
                            securityDomain = this.elementAsString(reader, "security-domain", expressions);
                            break block0;
                        }
                        case "reauth-plugin": {
                            reauthPlugin = this.parseExtension(reader, "reauth-plugin");
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Validation parseValidationSetting(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean validateOnMatch = Defaults.VALIDATE_ON_MATCH;
        Boolean useFastFail = Defaults.USE_CCM;
        Long backgroundValidationMillis = null;
        Extension staleConnectionChecker = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        String checkValidConnectionSql = null;
        Extension validConnectionChecker = null;
        Extension exceptionSorter = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("validation".equals(reader.getLocalName())) {
                        return new ValidationImpl(backgroundValidation, backgroundValidationMillis, useFastFail, validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "background-validation": 
                        case "background-validation-millis": 
                        case "check-valid-connection-sql": 
                        case "exception-sorter": 
                        case "stale-connection-checker": 
                        case "use-fast-fail": 
                        case "validate-on-match": 
                        case "valid-connection-checker": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "background-validation": {
                            backgroundValidation = this.elementAsBoolean(reader, "background-validation", expressions);
                            break block0;
                        }
                        case "background-validation-millis": {
                            backgroundValidationMillis = this.elementAsLong(reader, "background-validation-millis", expressions);
                            break block0;
                        }
                        case "check-valid-connection-sql": {
                            checkValidConnectionSql = this.elementAsString(reader, "check-valid-connection-sql", expressions);
                            break block0;
                        }
                        case "exception-sorter": {
                            exceptionSorter = this.parseExtension(reader, "exception-sorter");
                            break block0;
                        }
                        case "stale-connection-checker": {
                            staleConnectionChecker = this.parseExtension(reader, "stale-connection-checker");
                            break block0;
                        }
                        case "use-fast-fail": {
                            useFastFail = this.elementAsBoolean(reader, "use-fast-fail", expressions);
                            break block0;
                        }
                        case "validate-on-match": {
                            validateOnMatch = this.elementAsBoolean(reader, "validate-on-match", expressions);
                            break block0;
                        }
                        case "valid-connection-checker": {
                            validConnectionChecker = this.parseExtension(reader, "valid-connection-checker");
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Timeout parseTimeoutSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long blockingTimeoutMillis = null;
        Integer idleTimeoutMinutes = null;
        Boolean setTxQuertTimeout = Defaults.SET_TX_QUERY_TIMEOUT;
        Long queryTimeout = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Long useTryLock = null;
        Integer xaResourceTimeout = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("timeout".equals(reader.getLocalName())) {
                        return new TimeoutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "allocation-retry": 
                        case "allocation-retry-wait-millis": 
                        case "blocking-timeout-millis": 
                        case "idle-timeout-minutes": 
                        case "query-timeout": 
                        case "set-tx-query-timeout": 
                        case "use-try-lock": 
                        case "xa-resource-timeout": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "allocation-retry": {
                            allocationRetry = this.elementAsInteger(reader, "allocation-retry", expressions);
                            break block0;
                        }
                        case "allocation-retry-wait-millis": {
                            allocationRetryWaitMillis = this.elementAsLong(reader, "allocation-retry-wait-millis", expressions);
                            break block0;
                        }
                        case "blocking-timeout-millis": {
                            blockingTimeoutMillis = this.elementAsLong(reader, "blocking-timeout-millis", expressions);
                            break block0;
                        }
                        case "idle-timeout-minutes": {
                            idleTimeoutMinutes = this.elementAsInteger(reader, "idle-timeout-minutes", expressions);
                            break block0;
                        }
                        case "query-timeout": {
                            queryTimeout = this.elementAsLong(reader, "query-timeout", expressions);
                            break block0;
                        }
                        case "set-tx-query-timeout": {
                            setTxQuertTimeout = this.elementAsBoolean(reader, "set-tx-query-timeout", expressions);
                            break block0;
                        }
                        case "use-try-lock": {
                            useTryLock = this.elementAsLong(reader, "use-try-lock", expressions);
                            break block0;
                        }
                        case "xa-resource-timeout": {
                            xaResourceTimeout = this.elementAsInteger(reader, "xa-resource-timeout", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Statement parseStatementSettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Long preparedStatementsCacheSize = null;
        Boolean sharePreparedStatements = Defaults.SHARE_PREPARED_STATEMENTS;
        Statement.TrackStatementsEnum trackStatements = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("statement".equals(reader.getLocalName())) {
                        return new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "prepared-statement-cache-size": 
                        case "track-statements": 
                        case "share-prepared-statements": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "prepared-statement-cache-size": {
                            preparedStatementsCacheSize = this.elementAsLong(reader, "prepared-statement-cache-size", expressions);
                            break block0;
                        }
                        case "track-statements": {
                            String elementString = this.elementAsString(reader, "track-statements", expressions);
                            trackStatements = Statement.TrackStatementsEnum.valueOf(elementString == null ? "FALSE" : elementString.toUpperCase(Locale.US));
                            break block0;
                        }
                        case "share-prepared-statements": {
                            sharePreparedStatements = this.elementAsBoolean(reader, "share-prepared-statements", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DsPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String type = Defaults.TYPE;
        String janitor = Defaults.JANITOR;
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        Extension connectionListener = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block42: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.attributeAsString(reader, "type", expressions);
                    continue block42;
                }
                case "janitor": {
                    janitor = this.attributeAsString(reader, "janitor", expressions);
                    continue block42;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if ("pool".equals(reader.getLocalName())) {
                        return new DsPoolImpl(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, capacity, connectionListener, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "max-pool-size": 
                        case "initial-pool-size": 
                        case "min-pool-size": 
                        case "prefill": 
                        case "flush-strategy": 
                        case "capacity": 
                        case "connection-listener": {
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "max-pool-size": {
                            maxPoolSize = this.elementAsInteger(reader, "max-pool-size", expressions);
                            break block8;
                        }
                        case "initial-pool-size": {
                            initialPoolSize = this.elementAsInteger(reader, "initial-pool-size", expressions);
                            break block8;
                        }
                        case "min-pool-size": {
                            minPoolSize = this.elementAsInteger(reader, "min-pool-size", expressions);
                            break block8;
                        }
                        case "prefill": {
                            prefill = this.elementAsBoolean(reader, "prefill", expressions);
                            break block8;
                        }
                        case "flush-strategy": {
                            flushStrategy = this.elementAsFlushStrategy(reader, expressions);
                            break block8;
                        }
                        case "capacity": {
                            capacity = this.parseCapacity(reader);
                            break block8;
                        }
                        case "connection-listener": {
                            connectionListener = this.parseExtension(reader, "connection-listener");
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DsXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String type = Defaults.TYPE;
        String janitor = Defaults.JANITOR;
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer initialPoolSize = Defaults.INITIAL_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Capacity capacity = null;
        Extension connectionListener = null;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block51: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.attributeAsString(reader, "type", expressions);
                    continue block51;
                }
                case "janitor": {
                    janitor = this.attributeAsString(reader, "janitor", expressions);
                    continue block51;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if ("xa-pool".equals(reader.getLocalName())) {
                        return new DsXaPoolImpl(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, isSameRmOverride, padXid, wrapXaDataSource, capacity, connectionListener, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "max-pool-size": 
                        case "initial-pool-size": 
                        case "min-pool-size": 
                        case "is-same-rm-override": 
                        case "pad-xid": 
                        case "wrap-xa-resource": 
                        case "prefill": 
                        case "flush-strategy": 
                        case "capacity": 
                        case "connection-listener": {
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "max-pool-size": {
                            maxPoolSize = this.elementAsInteger(reader, "max-pool-size", expressions);
                            break block8;
                        }
                        case "initial-pool-size": {
                            initialPoolSize = this.elementAsInteger(reader, "initial-pool-size", expressions);
                            break block8;
                        }
                        case "min-pool-size": {
                            minPoolSize = this.elementAsInteger(reader, "min-pool-size", expressions);
                            break block8;
                        }
                        case "is-same-rm-override": {
                            isSameRmOverride = this.elementAsBoolean(reader, "is-same-rm-override", expressions);
                            break block8;
                        }
                        case "pad-xid": {
                            padXid = this.elementAsBoolean(reader, "pad-xid", expressions);
                            break block8;
                        }
                        case "wrap-xa-resource": {
                            wrapXaDataSource = this.elementAsBoolean(reader, "wrap-xa-resource", expressions);
                            break block8;
                        }
                        case "prefill": {
                            prefill = this.elementAsBoolean(reader, "prefill", expressions);
                            break block8;
                        }
                        case "flush-strategy": {
                            flushStrategy = this.elementAsFlushStrategy(reader, expressions);
                            break block8;
                        }
                        case "capacity": {
                            capacity = this.parseCapacity(reader);
                            break block8;
                        }
                        case "connection-listener": {
                            connectionListener = this.parseExtension(reader, "connection-listener");
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        Timeout timeoutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlProperty = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        String id = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block73: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "enabled": {
                    enabled = this.attributeAsBoolean(reader, "enabled", Defaults.ENABLED, expressions);
                    continue block73;
                }
                case "jndi-name": {
                    jndiName = this.attributeAsString(reader, "jndi-name", expressions);
                    continue block73;
                }
                case "id": {
                    id = this.attributeAsString(reader, "id", expressions);
                    continue block73;
                }
                case "spy": {
                    spy = this.attributeAsBoolean(reader, "spy", Defaults.SPY, expressions);
                    continue block73;
                }
                case "use-ccm": {
                    useCcm = this.attributeAsBoolean(reader, "use-ccm", Defaults.USE_CCM, expressions);
                    continue block73;
                }
                case "connectable": {
                    connectable = this.attributeAsBoolean(reader, "connectable", Defaults.CONNECTABLE, expressions);
                    continue block73;
                }
                case "tracking": {
                    tracking = this.attributeAsBoolean(reader, "tracking", Defaults.TRACKING, expressions);
                    continue block73;
                }
            }
        }
        while (reader.hasNext()) {
            block18 : switch (reader.nextTag()) {
                case 2: {
                    if ("xa-datasource".equals(reader.getLocalName())) {
                        return new XADataSourceImpl(transactionIsolation, timeoutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlProperty, urlSelectorStrategyClassName, id, enabled, jndiName, spy, useCcm, connectable, tracking, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "xa-datasource-property": 
                        case "xa-datasource-class": 
                        case "driver": 
                        case "xa-pool": 
                        case "new-connection-sql": 
                        case "url-delimiter": 
                        case "url-property": 
                        case "url-selector-strategy-class-name": 
                        case "transaction-isolation": 
                        case "security": 
                        case "statement": 
                        case "timeout": 
                        case "validation": 
                        case "recovery": {
                            break block18;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "xa-datasource-property": {
                            this.parseConfigProperty(xaDataSourceProperty, reader, "xa-datasource-property", expressions);
                            break block18;
                        }
                        case "xa-datasource-class": {
                            xaDataSourceClass = this.elementAsString(reader, "xa-datasource-class", expressions);
                            break block18;
                        }
                        case "driver": {
                            driver = this.elementAsString(reader, "driver", expressions);
                            break block18;
                        }
                        case "xa-pool": {
                            xaPool = this.parseXaPool(reader);
                            break block18;
                        }
                        case "new-connection-sql": {
                            newConnectionSql = this.elementAsString(reader, "new-connection-sql", expressions);
                            break block18;
                        }
                        case "url-delimiter": {
                            urlDelimiter = this.elementAsString(reader, "url-delimiter", expressions);
                            break block18;
                        }
                        case "url-property": {
                            urlProperty = this.elementAsString(reader, "url-property", expressions);
                            break block18;
                        }
                        case "url-selector-strategy-class-name": {
                            urlSelectorStrategyClassName = this.elementAsString(reader, "url-selector-strategy-class-name", expressions);
                            break block18;
                        }
                        case "transaction-isolation": {
                            String str = this.elementAsString(reader, "transaction-isolation", expressions);
                            transactionIsolation = TransactionIsolation.forName(str);
                            if (transactionIsolation != null) break block18;
                            transactionIsolation = TransactionIsolation.customLevel(str);
                            break block18;
                        }
                        case "security": {
                            securitySettings = this.parseDsSecurity(reader);
                            break block18;
                        }
                        case "statement": {
                            statementSettings = this.parseStatementSettings(reader);
                            break block18;
                        }
                        case "timeout": {
                            timeoutSettings = this.parseTimeoutSettings(reader);
                            break block18;
                        }
                        case "validation": {
                            validationSettings = this.parseValidationSetting(reader);
                            break block18;
                        }
                        case "recovery": {
                            recovery = this.parseRecovery(reader);
                            break block18;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        Timeout timeoutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsPool pool = null;
        String id = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        Boolean connectable = Defaults.CONNECTABLE;
        Boolean tracking = Defaults.TRACKING;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block75: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "enabled": {
                    enabled = this.attributeAsBoolean(reader, "enabled", Defaults.ENABLED, expressions);
                    continue block75;
                }
                case "jndi-name": {
                    jndiName = this.attributeAsString(reader, "jndi-name", expressions);
                    continue block75;
                }
                case "id": {
                    id = this.attributeAsString(reader, "id", expressions);
                    continue block75;
                }
                case "spy": {
                    spy = this.attributeAsBoolean(reader, "spy", Defaults.SPY, expressions);
                    continue block75;
                }
                case "use-ccm": {
                    useCcm = this.attributeAsBoolean(reader, "use-ccm", Defaults.USE_CCM, expressions);
                    continue block75;
                }
                case "jta": {
                    jta = this.attributeAsBoolean(reader, "jta", Defaults.JTA, expressions);
                    continue block75;
                }
                case "connectable": {
                    connectable = this.attributeAsBoolean(reader, "connectable", Defaults.CONNECTABLE, expressions);
                    continue block75;
                }
                case "tracking": {
                    tracking = this.attributeAsBoolean(reader, "tracking", Defaults.TRACKING, expressions);
                    continue block75;
                }
            }
        }
        while (reader.hasNext()) {
            block20 : switch (reader.nextTag()) {
                case 2: {
                    if ("datasource".equals(reader.getLocalName())) {
                        return new DataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeoutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, id, enabled, jndiName, spy, useCcm, jta, connectable, tracking, pool, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "connection-property": 
                        case "connection-url": 
                        case "driver-class": 
                        case "datasource-class": 
                        case "driver": 
                        case "pool": 
                        case "new-connection-sql": 
                        case "url-delimiter": 
                        case "url-selector-strategy-class-name": 
                        case "transaction-isolation": 
                        case "security": 
                        case "statement": 
                        case "timeout": 
                        case "validation": {
                            break block20;
                        }
                    }
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "connection-property": {
                            this.parseConfigProperty(connectionProperties, reader, "connection-property", expressions);
                            break block20;
                        }
                        case "connection-url": {
                            connectionUrl = this.elementAsString(reader, "connection-url", expressions);
                            break block20;
                        }
                        case "driver-class": {
                            driverClass = this.elementAsString(reader, "driver-class", expressions);
                            break block20;
                        }
                        case "datasource-class": {
                            dataSourceClass = this.elementAsString(reader, "datasource-class", expressions);
                            break block20;
                        }
                        case "driver": {
                            driver = this.elementAsString(reader, "driver", expressions);
                            break block20;
                        }
                        case "pool": {
                            pool = this.parsePool(reader);
                            break block20;
                        }
                        case "new-connection-sql": {
                            newConnectionSql = this.elementAsString(reader, "new-connection-sql", expressions);
                            break block20;
                        }
                        case "url-delimiter": {
                            urlDelimiter = this.elementAsString(reader, "url-delimiter", expressions);
                            break block20;
                        }
                        case "url-selector-strategy-class-name": {
                            urlSelectorStrategyClassName = this.elementAsString(reader, "url-selector-strategy-class-name", expressions);
                            break block20;
                        }
                        case "transaction-isolation": {
                            String str = this.elementAsString(reader, "transaction-isolation", expressions);
                            transactionIsolation = TransactionIsolation.forName(str);
                            if (transactionIsolation != null) break block20;
                            transactionIsolation = TransactionIsolation.customLevel(str);
                            break block20;
                        }
                        case "security": {
                            securitySettings = this.parseDsSecurity(reader);
                            break block20;
                        }
                        case "statement": {
                            statementSettings = this.parseStatementSettings(reader);
                            break block20;
                        }
                        case "timeout": {
                            timeoutSettings = this.parseTimeoutSettings(reader);
                            break block20;
                        }
                        case "validation": {
                            validationSettings = this.parseValidationSetting(reader);
                            break block20;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected Recovery parseRecovery(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Boolean noRecovery = Defaults.NO_RECOVERY;
        Credential security = null;
        Extension plugin = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        block27: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "no-recovery": {
                    noRecovery = this.attributeAsBoolean(reader, "no-recovery", Boolean.FALSE, expressions);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "recovery": {
                            return new RecoveryImpl(security, plugin, noRecovery, !expressions.isEmpty() ? expressions : null);
                        }
                        case "recovery-credential": 
                        case "recovery-plugin": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "recovery-credential": {
                            security = this.parseCredential(reader);
                            break block6;
                        }
                        case "recovery-plugin": {
                            plugin = this.parseExtension(reader, "recovery-plugin");
                            break block6;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    switch (reader.getLocalName()) {
                        case "security": 
                        case "recovery-credential": {
                            return new CredentialImpl(userName, password, securityDomain, !expressions.isEmpty() ? expressions : null);
                        }
                        case "user-name": 
                        case "password": 
                        case "security-domain": {
                            break;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                        }
                    }
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "user-name": {
                            userName = this.elementAsString(reader, "user-name", expressions);
                            break block0;
                        }
                        case "password": {
                            password = this.elementAsString(reader, "password", expressions);
                            break block0;
                        }
                        case "security-domain": {
                            securityDomain = this.elementAsString(reader, "security-domain", expressions);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void storeDataSource(DataSource ds, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("datasource");
        if (ds.isJTA() != null && (ds.hasExpression("jta") || !Defaults.JTA.equals(ds.isJTA()))) {
            writer.writeAttribute("jta", ds.getValue("jta", ds.isJTA().toString()));
        }
        if (ds.getJndiName() != null) {
            writer.writeAttribute("jndi-name", ds.getValue("jndi-name", ds.getJndiName()));
        }
        if (ds.getId() != null) {
            writer.writeAttribute("id", ds.getValue("id", ds.getId()));
        }
        if (ds.isEnabled() != null && (ds.hasExpression("enabled") || !Defaults.ENABLED.equals(ds.isEnabled()))) {
            writer.writeAttribute("enabled", ds.getValue("enabled", ds.isEnabled().toString()));
        }
        if (ds.isSpy() != null && (ds.hasExpression("spy") || !Defaults.SPY.equals(ds.isSpy()))) {
            writer.writeAttribute("spy", ds.getValue("spy", ds.isSpy().toString()));
        }
        if (ds.isUseCcm() != null && (ds.hasExpression("use-ccm") || !Defaults.USE_CCM.equals(ds.isUseCcm()))) {
            writer.writeAttribute("use-ccm", ds.getValue("use-ccm", ds.isUseCcm().toString()));
        }
        if (ds.isConnectable() != null && (ds.hasExpression("connectable") || !Defaults.CONNECTABLE.equals(ds.isConnectable()))) {
            writer.writeAttribute("connectable", ds.getValue("connectable", ds.isConnectable().toString()));
        }
        if (ds.isTracking() != null) {
            writer.writeAttribute("tracking", ds.getValue("tracking", ds.isTracking().toString()));
        }
        if (ds.getConnectionUrl() != null) {
            writer.writeStartElement("connection-url");
            writer.writeCharacters(ds.getValue("connection-url", ds.getConnectionUrl()));
            writer.writeEndElement();
        }
        if (ds.getDriverClass() != null) {
            writer.writeStartElement("driver-class");
            writer.writeCharacters(ds.getValue("driver-class", ds.getDriverClass()));
            writer.writeEndElement();
        }
        if (ds.getDataSourceClass() != null) {
            writer.writeStartElement("datasource-class");
            writer.writeCharacters(ds.getValue("datasource-class", ds.getDataSourceClass()));
            writer.writeEndElement();
        }
        if (ds.getDriver() != null) {
            writer.writeStartElement("driver");
            writer.writeCharacters(ds.getValue("driver", ds.getDriver()));
            writer.writeEndElement();
        }
        if (ds.getConnectionProperties() != null && !ds.getConnectionProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : ds.getConnectionProperties().entrySet()) {
                writer.writeStartElement("connection-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(ds.getValue("connection-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        if (ds.getNewConnectionSql() != null) {
            writer.writeStartElement("new-connection-sql");
            writer.writeCharacters(ds.getValue("new-connection-sql", ds.getNewConnectionSql()));
            writer.writeEndElement();
        }
        if (ds.getTransactionIsolation() != null) {
            writer.writeStartElement("transaction-isolation");
            writer.writeCharacters(ds.getValue("transaction-isolation", ds.getTransactionIsolation().toString()));
            writer.writeEndElement();
        }
        if (ds.getUrlDelimiter() != null) {
            writer.writeStartElement("url-delimiter");
            writer.writeCharacters(ds.getValue("url-delimiter", ds.getUrlDelimiter()));
            writer.writeEndElement();
        }
        if (ds.getUrlSelectorStrategyClassName() != null) {
            writer.writeStartElement("url-selector-strategy-class-name");
            writer.writeCharacters(ds.getValue("url-selector-strategy-class-name", ds.getUrlSelectorStrategyClassName()));
            writer.writeEndElement();
        }
        if (ds.getPool() != null) {
            this.storePool(ds.getPool(), writer);
        }
        if (ds.getSecurity() != null) {
            this.storeSecurity(ds.getSecurity(), writer);
        }
        if (ds.getValidation() != null) {
            this.storeValidation(ds.getValidation(), writer);
        }
        if (ds.getTimeout() != null) {
            this.storeTimeout(ds.getTimeout(), writer);
        }
        if (ds.getStatement() != null) {
            this.storeStatement(ds.getStatement(), writer);
        }
        writer.writeEndElement();
    }

    protected void storeXaDataSource(XaDataSource xads, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("xa-datasource");
        if (xads.getJndiName() != null) {
            writer.writeAttribute("jndi-name", xads.getValue("jndi-name", xads.getJndiName()));
        }
        if (xads.getId() != null) {
            writer.writeAttribute("id", xads.getValue("id", xads.getId()));
        }
        if (xads.isEnabled() != null && (xads.hasExpression("enabled") || !Defaults.ENABLED.equals(xads.isEnabled()))) {
            writer.writeAttribute("enabled", xads.getValue("enabled", xads.isEnabled().toString()));
        }
        if (xads.isSpy() != null && (xads.hasExpression("spy") || !Defaults.SPY.equals(xads.isSpy()))) {
            writer.writeAttribute("spy", xads.getValue("spy", xads.isSpy().toString()));
        }
        if (xads.isUseCcm() != null && (xads.hasExpression("use-ccm") || !Defaults.USE_CCM.equals(xads.isUseCcm()))) {
            writer.writeAttribute("use-ccm", xads.getValue("use-ccm", xads.isUseCcm().toString()));
        }
        if (xads.isConnectable() != null && (xads.hasExpression("connectable") || !Defaults.CONNECTABLE.equals(xads.isConnectable()))) {
            writer.writeAttribute("connectable", xads.getValue("connectable", xads.isConnectable().toString()));
        }
        if (xads.isTracking() != null) {
            writer.writeAttribute("tracking", xads.getValue("tracking", xads.isTracking().toString()));
        }
        if (xads.getXaDataSourceProperty() != null && !xads.getXaDataSourceProperty().isEmpty()) {
            for (Map.Entry<String, String> entry : xads.getXaDataSourceProperty().entrySet()) {
                writer.writeStartElement("xa-datasource-property");
                writer.writeAttribute("name", entry.getKey());
                writer.writeCharacters(xads.getValue("xa-datasource-property", entry.getKey(), entry.getValue()));
                writer.writeEndElement();
            }
        }
        if (xads.getXaDataSourceClass() != null) {
            writer.writeStartElement("xa-datasource-class");
            writer.writeCharacters(xads.getValue("xa-datasource-class", xads.getXaDataSourceClass()));
            writer.writeEndElement();
        }
        if (xads.getDriver() != null) {
            writer.writeStartElement("driver");
            writer.writeCharacters(xads.getValue("driver", xads.getDriver()));
            writer.writeEndElement();
        }
        if (xads.getUrlDelimiter() != null) {
            writer.writeStartElement("url-delimiter");
            writer.writeCharacters(xads.getValue("url-delimiter", xads.getUrlDelimiter()));
            writer.writeEndElement();
        }
        if (xads.getUrlProperty() != null) {
            writer.writeStartElement("url-property");
            writer.writeCharacters(xads.getValue("url-property", xads.getUrlProperty()));
            writer.writeEndElement();
        }
        if (xads.getUrlSelectorStrategyClassName() != null) {
            writer.writeStartElement("url-selector-strategy-class-name");
            writer.writeCharacters(xads.getValue("url-selector-strategy-class-name", xads.getUrlSelectorStrategyClassName()));
            writer.writeEndElement();
        }
        if (xads.getNewConnectionSql() != null) {
            writer.writeStartElement("new-connection-sql");
            writer.writeCharacters(xads.getValue("new-connection-sql", xads.getNewConnectionSql()));
            writer.writeEndElement();
        }
        if (xads.getTransactionIsolation() != null) {
            writer.writeStartElement("transaction-isolation");
            writer.writeCharacters(xads.getValue("transaction-isolation", xads.getTransactionIsolation().toString()));
            writer.writeEndElement();
        }
        if (xads.getXaPool() != null) {
            this.storeXaPool(xads.getXaPool(), writer);
        }
        if (xads.getSecurity() != null) {
            this.storeSecurity(xads.getSecurity(), writer);
        }
        if (xads.getValidation() != null) {
            this.storeValidation(xads.getValidation(), writer);
        }
        if (xads.getTimeout() != null) {
            this.storeTimeout(xads.getTimeout(), writer);
        }
        if (xads.getStatement() != null) {
            this.storeStatement(xads.getStatement(), writer);
        }
        if (xads.getRecovery() != null) {
            this.storeRecovery(xads.getRecovery(), writer);
        }
        writer.writeEndElement();
    }

    protected void storeDriver(Driver drv, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("driver");
        if (drv.getName() != null) {
            writer.writeAttribute("name", drv.getValue("name", drv.getName()));
        }
        if (drv.getModule() != null) {
            writer.writeAttribute("module", drv.getValue("module", drv.getModule()));
        }
        if (drv.getMajorVersion() != null) {
            writer.writeAttribute("major-version", drv.getValue("major-version", drv.getMajorVersion().toString()));
        }
        if (drv.getMinorVersion() != null) {
            writer.writeAttribute("minor-version", drv.getValue("minor-version", drv.getMinorVersion().toString()));
        }
        if (drv.getDriverClass() != null) {
            writer.writeStartElement("driver-class");
            writer.writeCharacters(drv.getValue("driver-class", drv.getDriverClass()));
            writer.writeEndElement();
        }
        if (drv.getDataSourceClass() != null) {
            writer.writeStartElement("datasource-class");
            writer.writeCharacters(drv.getValue("datasource-class", drv.getDataSourceClass()));
            writer.writeEndElement();
        }
        if (drv.getXaDataSourceClass() != null) {
            writer.writeStartElement("xa-datasource-class");
            writer.writeCharacters(drv.getValue("xa-datasource-class", drv.getXaDataSourceClass()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storePool(DsPool pool, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("pool");
        if (pool.getMinPoolSize() != null && (pool.hasExpression("min-pool-size") || !Defaults.MIN_POOL_SIZE.equals(pool.getMinPoolSize()))) {
            writer.writeStartElement("min-pool-size");
            writer.writeCharacters(pool.getValue("min-pool-size", pool.getMinPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getInitialPoolSize() != null) {
            writer.writeStartElement("initial-pool-size");
            writer.writeCharacters(pool.getValue("initial-pool-size", pool.getInitialPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getMaxPoolSize() != null && (pool.hasExpression("max-pool-size") || !Defaults.MAX_POOL_SIZE.equals(pool.getMaxPoolSize()))) {
            writer.writeStartElement("max-pool-size");
            writer.writeCharacters(pool.getValue("max-pool-size", pool.getMaxPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.isPrefill() != null && (pool.hasExpression("prefill") || !Defaults.PREFILL.equals(pool.isPrefill()))) {
            writer.writeStartElement("prefill");
            writer.writeCharacters(pool.getValue("prefill", pool.isPrefill().toString()));
            writer.writeEndElement();
        }
        if (pool.getFlushStrategy() != null && (pool.hasExpression("flush-strategy") || !Defaults.FLUSH_STRATEGY.equals((Object)pool.getFlushStrategy()))) {
            writer.writeStartElement("flush-strategy");
            writer.writeCharacters(pool.getValue("flush-strategy", pool.getFlushStrategy().toString()));
            writer.writeEndElement();
        }
        if (pool.getCapacity() != null) {
            this.storeCapacity(pool.getCapacity(), writer);
        }
        if (pool.getConnectionListener() != null) {
            writer.writeStartElement("connection-listener");
            writer.writeAttribute("class-name", pool.getConnectionListener().getValue("class-name", pool.getConnectionListener().getClassName()));
            if (!pool.getConnectionListener().getConfigPropertiesMap().isEmpty()) {
                for (Map.Entry<String, String> entry : pool.getConnectionListener().getConfigPropertiesMap().entrySet()) {
                    writer.writeStartElement("config-property");
                    writer.writeAttribute("name", entry.getKey());
                    writer.writeCharacters(pool.getConnectionListener().getValue("config-property", entry.getKey(), entry.getValue()));
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeXaPool(DsXaPool pool, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("xa-pool");
        if (pool.getMinPoolSize() != null && (pool.hasExpression("min-pool-size") || !Defaults.MIN_POOL_SIZE.equals(pool.getMinPoolSize()))) {
            writer.writeStartElement("min-pool-size");
            writer.writeCharacters(pool.getValue("min-pool-size", pool.getMinPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getInitialPoolSize() != null) {
            writer.writeStartElement("initial-pool-size");
            writer.writeCharacters(pool.getValue("initial-pool-size", pool.getInitialPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.getMaxPoolSize() != null && (pool.hasExpression("max-pool-size") || !Defaults.MAX_POOL_SIZE.equals(pool.getMaxPoolSize()))) {
            writer.writeStartElement("max-pool-size");
            writer.writeCharacters(pool.getValue("max-pool-size", pool.getMaxPoolSize().toString()));
            writer.writeEndElement();
        }
        if (pool.isPrefill() != null && (pool.hasExpression("prefill") || !Defaults.PREFILL.equals(pool.isPrefill()))) {
            writer.writeStartElement("prefill");
            writer.writeCharacters(pool.getValue("prefill", pool.isPrefill().toString()));
            writer.writeEndElement();
        }
        if (pool.getFlushStrategy() != null && (pool.hasExpression("flush-strategy") || !Defaults.FLUSH_STRATEGY.equals((Object)pool.getFlushStrategy()))) {
            writer.writeStartElement("flush-strategy");
            writer.writeCharacters(pool.getValue("flush-strategy", pool.getFlushStrategy().toString()));
            writer.writeEndElement();
        }
        if (pool.getCapacity() != null) {
            this.storeCapacity(pool.getCapacity(), writer);
        }
        if (pool.getConnectionListener() != null) {
            this.storeExtension(pool.getConnectionListener(), writer, "connection-listener");
        }
        if (pool.isIsSameRmOverride() != null) {
            writer.writeStartElement("is-same-rm-override");
            writer.writeCharacters(pool.getValue("is-same-rm-override", pool.isIsSameRmOverride().toString()));
            writer.writeEndElement();
        }
        if (pool.isPadXid() != null && (pool.hasExpression("pad-xid") || !Defaults.PAD_XID.equals(pool.isPadXid()))) {
            writer.writeStartElement("pad-xid");
            writer.writeCharacters(pool.getValue("pad-xid", pool.isPadXid().toString()));
            writer.writeEndElement();
        }
        if (pool.isWrapXaResource() != null && (pool.hasExpression("wrap-xa-resource") || !Defaults.WRAP_XA_RESOURCE.equals(pool.isWrapXaResource()))) {
            writer.writeStartElement("wrap-xa-resource");
            writer.writeCharacters(pool.getValue("wrap-xa-resource", pool.isWrapXaResource().toString()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeSecurity(DsSecurity s, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("security");
        if (s.getUserName() != null) {
            writer.writeStartElement("user-name");
            writer.writeCharacters(s.getValue("user-name", s.getUserName()));
            writer.writeEndElement();
            writer.writeStartElement("password");
            writer.writeCharacters(s.getValue("password", s.getPassword()));
            writer.writeEndElement();
        } else if (s.getSecurityDomain() != null) {
            writer.writeStartElement("security-domain");
            writer.writeCharacters(s.getValue("security-domain", s.getSecurityDomain()));
            writer.writeEndElement();
        }
        if (s.getReauthPlugin() != null) {
            this.storeExtension(s.getReauthPlugin(), writer, "reauth-plugin");
        }
        writer.writeEndElement();
    }

    protected void storeValidation(Validation v, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("validation");
        if (v.getValidConnectionChecker() != null) {
            this.storeExtension(v.getValidConnectionChecker(), writer, "valid-connection-checker");
        }
        if (v.getCheckValidConnectionSql() != null) {
            writer.writeStartElement("check-valid-connection-sql");
            writer.writeCharacters(v.getValue("check-valid-connection-sql", v.getCheckValidConnectionSql()));
            writer.writeEndElement();
        }
        if (v.isValidateOnMatch() != null) {
            writer.writeStartElement("validate-on-match");
            writer.writeCharacters(v.getValue("validate-on-match", v.isValidateOnMatch().toString()));
            writer.writeEndElement();
        }
        if (v.isBackgroundValidation() != null) {
            writer.writeStartElement("background-validation");
            writer.writeCharacters(v.getValue("background-validation", v.isBackgroundValidation().toString()));
            writer.writeEndElement();
        }
        if (v.getBackgroundValidationMillis() != null) {
            writer.writeStartElement("background-validation-millis");
            writer.writeCharacters(v.getValue("background-validation-millis", v.getBackgroundValidationMillis().toString()));
            writer.writeEndElement();
        }
        if (v.isUseFastFail() != null) {
            writer.writeStartElement("use-fast-fail");
            writer.writeCharacters(v.getValue("use-fast-fail", v.isUseFastFail().toString()));
            writer.writeEndElement();
        }
        if (v.getStaleConnectionChecker() != null) {
            this.storeExtension(v.getStaleConnectionChecker(), writer, "stale-connection-checker");
        }
        if (v.getExceptionSorter() != null) {
            this.storeExtension(v.getExceptionSorter(), writer, "exception-sorter");
        }
        writer.writeEndElement();
    }

    protected void storeTimeout(Timeout t, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("timeout");
        if (t.getBlockingTimeoutMillis() != null) {
            writer.writeStartElement("blocking-timeout-millis");
            writer.writeCharacters(t.getValue("blocking-timeout-millis", t.getBlockingTimeoutMillis().toString()));
            writer.writeEndElement();
        }
        if (t.getIdleTimeoutMinutes() != null) {
            writer.writeStartElement("idle-timeout-minutes");
            writer.writeCharacters(t.getValue("idle-timeout-minutes", t.getIdleTimeoutMinutes().toString()));
            writer.writeEndElement();
        }
        if (t.isSetTxQueryTimeout() != null && Boolean.TRUE.equals(t.isSetTxQueryTimeout())) {
            writer.writeEmptyElement("set-tx-query-timeout");
        }
        if (t.getQueryTimeout() != null) {
            writer.writeStartElement("query-timeout");
            writer.writeCharacters(t.getValue("query-timeout", t.getQueryTimeout().toString()));
            writer.writeEndElement();
        }
        if (t.getUseTryLock() != null) {
            writer.writeStartElement("use-try-lock");
            writer.writeCharacters(t.getValue("use-try-lock", t.getUseTryLock().toString()));
            writer.writeEndElement();
        }
        if (t.getAllocationRetry() != null) {
            writer.writeStartElement("allocation-retry");
            writer.writeCharacters(t.getValue("allocation-retry", t.getAllocationRetry().toString()));
            writer.writeEndElement();
        }
        if (t.getAllocationRetryWaitMillis() != null) {
            writer.writeStartElement("allocation-retry-wait-millis");
            writer.writeCharacters(t.getValue("allocation-retry-wait-millis", t.getAllocationRetryWaitMillis().toString()));
            writer.writeEndElement();
        }
        if (t.getXaResourceTimeout() != null) {
            writer.writeStartElement("xa-resource-timeout");
            writer.writeCharacters(t.getValue("xa-resource-timeout", t.getXaResourceTimeout().toString()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    protected void storeStatement(Statement s, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("statement");
        if (s.getTrackStatements() != null) {
            writer.writeStartElement("track-statements");
            writer.writeCharacters(s.getValue("track-statements", s.getTrackStatements().toString()));
            writer.writeEndElement();
        }
        if (s.getPreparedStatementsCacheSize() != null) {
            writer.writeStartElement("prepared-statement-cache-size");
            writer.writeCharacters(s.getValue("prepared-statement-cache-size", s.getPreparedStatementsCacheSize().toString()));
            writer.writeEndElement();
        }
        if (s.isSharePreparedStatements() != null && Boolean.TRUE.equals(s.isSharePreparedStatements())) {
            writer.writeEmptyElement("share-prepared-statements");
        }
        writer.writeEndElement();
    }

    @Override
    protected void storeRecovery(Recovery r, XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("recovery");
        if (r.isNoRecovery() != null) {
            writer.writeAttribute("no-recovery", r.getValue("no-recovery", r.isNoRecovery().toString()));
        }
        if (r.getCredential() != null) {
            writer.writeStartElement("recovery-credential");
            Credential c = (Credential)r.getCredential();
            if (c.getUserName() != null) {
                writer.writeStartElement("user-name");
                writer.writeCharacters(c.getValue("user-name", c.getUserName()));
                writer.writeEndElement();
                writer.writeStartElement("password");
                writer.writeCharacters(c.getValue("password", c.getPassword()));
                writer.writeEndElement();
            } else {
                writer.writeStartElement("security-domain");
                writer.writeCharacters(c.getValue("security-domain", c.getSecurityDomain()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (r.getPlugin() != null) {
            this.storeExtension(r.getPlugin(), writer, "recovery-plugin");
        }
        writer.writeEndElement();
    }
}

