/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Capacity;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.common.api.metadata.ds.DsPool;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.PoolImpl;

public class DsPoolImpl
extends PoolImpl
implements DsPool {
    private static final long serialVersionUID = 1L;
    protected Extension connectionListener;

    public DsPoolImpl(String type, String janitor, Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, FlushStrategy flushStrategy, Capacity capacity, Extension connectionListener, Map<String, String> expressions) throws ValidateException {
        super(type, janitor, minPoolSize, initialPoolSize, maxPoolSize, prefill, flushStrategy, capacity, expressions);
        this.connectionListener = connectionListener;
    }

    @Override
    public Extension getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectionListener == null ? 7 : 7 * this.connectionListener.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DsPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DsPoolImpl other = (DsPoolImpl)obj;
        return !(this.connectionListener == null ? other.connectionListener != null : !this.connectionListener.equals(other.connectionListener));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool");
        if (this.type != null) {
            sb.append(" ").append("type").append("=\"");
            sb.append(this.type);
            sb.append("\"");
        }
        if (this.janitor != null) {
            sb.append(" ").append("janitor").append("=\"");
            sb.append(this.janitor);
            sb.append("\"");
        }
        sb.append(">");
        if (this.minPoolSize != null && !Defaults.MIN_POOL_SIZE.equals(this.minPoolSize)) {
            sb.append("<").append("min-pool-size").append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append("min-pool-size").append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append("initial-pool-size").append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append("initial-pool-size").append(">");
        }
        if (this.maxPoolSize != null && !Defaults.MAX_POOL_SIZE.equals(this.maxPoolSize)) {
            sb.append("<").append("max-pool-size").append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append("max-pool-size").append(">");
        }
        if (this.prefill != null && !Defaults.PREFILL.equals(this.prefill)) {
            sb.append("<").append("prefill").append(">");
            sb.append(this.prefill);
            sb.append("</").append("prefill").append(">");
        }
        if (this.flushStrategy != null && !Defaults.FLUSH_STRATEGY.equals((Object)this.flushStrategy)) {
            sb.append("<").append("flush-strategy").append(">");
            sb.append((Object)this.flushStrategy);
            sb.append("</").append("flush-strategy").append(">");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        if (this.connectionListener != null) {
            sb.append("<").append("connection-listener");
            sb.append(this.connectionListener.toString());
            sb.append("</").append("connection-listener").append(">");
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

