/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.ds.Credential;
import org.ironjacamar.common.api.validator.ValidateException;

public class RecoveryImpl
extends org.ironjacamar.common.metadata.common.RecoveryImpl {
    private static final long serialVersionUID = 1L;
    private Credential credential;

    public RecoveryImpl(Credential credential, Extension plugin, Boolean noRecovery, Map<String, String> expressions) throws ValidateException {
        super(credential, plugin, noRecovery, expressions);
        this.credential = credential;
    }

    @Override
    public Credential getCredential() {
        return this.credential;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<recovery");
        if (this.noRecovery != null) {
            sb.append(" ").append("no-recovery").append("=\"").append(this.noRecovery).append("\"");
        }
        sb.append(">");
        if (this.credential != null) {
            sb.append("<").append("recovery-credential").append(">");
            if (this.credential.getUserName() != null) {
                sb.append("<").append("user-name").append(">");
                sb.append(this.credential.getUserName());
                sb.append("</").append("user-name").append(">");
                sb.append("<").append("password").append(">");
                sb.append(this.credential.getPassword());
                sb.append("</").append("password").append(">");
            } else {
                sb.append("<").append("security-domain").append(">");
                sb.append(this.credential.getSecurityDomain());
                sb.append("</").append("security-domain").append(">");
            }
            sb.append("</").append("recovery-credential").append(">");
        }
        if (this.plugin != null) {
            sb.append("<").append("recovery-plugin");
            sb.append(this.plugin.toString());
            sb.append("</").append("recovery-plugin").append(">");
        }
        sb.append("</recovery>");
        return sb.toString();
    }
}

