/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.ds.Statement;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.common.AbstractMetadata;
import org.jboss.logging.Messages;

public class StatementImpl
extends AbstractMetadata
implements Statement {
    private static final long serialVersionUID = 3361665706947342366L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Boolean sharePreparedStatements;
    private final Long preparedStatementsCacheSize;
    private final Statement.TrackStatementsEnum trackStatements;

    public StatementImpl(Boolean sharePreparedStatements, Long preparedStatementsCacheSize, Statement.TrackStatementsEnum trackStatements, Map<String, String> expressions) throws ValidateException {
        super(expressions);
        this.sharePreparedStatements = sharePreparedStatements;
        this.preparedStatementsCacheSize = preparedStatementsCacheSize;
        this.trackStatements = trackStatements;
        this.validate();
    }

    @Override
    public final Boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    @Override
    public final Long getPreparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    @Override
    public final Statement.TrackStatementsEnum getTrackStatements() {
        return this.trackStatements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.preparedStatementsCacheSize == null ? 0 : this.preparedStatementsCacheSize.hashCode());
        result = 31 * result + (this.sharePreparedStatements == null ? 0 : this.sharePreparedStatements.hashCode());
        result = 31 * result + (this.trackStatements == null ? 0 : this.trackStatements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementImpl)) {
            return false;
        }
        StatementImpl other = (StatementImpl)obj;
        if (this.preparedStatementsCacheSize == null ? other.preparedStatementsCacheSize != null : !this.preparedStatementsCacheSize.equals(other.preparedStatementsCacheSize)) {
            return false;
        }
        if (this.sharePreparedStatements == null ? other.sharePreparedStatements != null : !this.sharePreparedStatements.equals(other.sharePreparedStatements)) {
            return false;
        }
        return this.trackStatements == other.trackStatements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<statement>");
        if (this.trackStatements != null) {
            sb.append("<").append("track-statements").append(">");
            sb.append((Object)this.trackStatements);
            sb.append("</").append("track-statements").append(">");
        }
        if (this.preparedStatementsCacheSize != null) {
            sb.append("<").append("prepared-statement-cache-size").append(">");
            sb.append(this.preparedStatementsCacheSize);
            sb.append("</").append("prepared-statement-cache-size").append(">");
        }
        if (this.sharePreparedStatements != null && Boolean.TRUE.equals(this.sharePreparedStatements)) {
            sb.append("<").append("share-prepared-statements").append("/>");
        }
        sb.append("</statement>");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidateException {
        if (this.preparedStatementsCacheSize != null && this.preparedStatementsCacheSize < 0L) {
            throw new ValidateException(bundle.invalidNegative("prepared-statement-cache-size"));
        }
    }
}

