/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.ds.Timeout;
import org.ironjacamar.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class TimeoutImpl
extends org.ironjacamar.common.metadata.common.TimeoutImpl
implements Timeout {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Boolean setTxQueryTimeout;
    private final Long queryTimeout;
    private final Long useTryLock;

    public TimeoutImpl(Long blockingTimeoutMillis, Integer idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout, Boolean setTxQueryTimeout, Long queryTimeout, Long useTryLock, Map<String, String> expressions) throws ValidateException {
        super(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, expressions);
        this.setTxQueryTimeout = setTxQueryTimeout;
        this.queryTimeout = queryTimeout;
        this.useTryLock = useTryLock;
        this.validate();
    }

    @Override
    public final Boolean isSetTxQueryTimeout() {
        return this.setTxQueryTimeout;
    }

    @Override
    public final Long getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final Long getUseTryLock() {
        return this.useTryLock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queryTimeout == null ? 0 : this.queryTimeout.hashCode());
        result = 31 * result + (this.setTxQueryTimeout == null ? 0 : this.setTxQueryTimeout.hashCode());
        result = 31 * result + (this.useTryLock == null ? 0 : this.useTryLock.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TimeoutImpl)) {
            return false;
        }
        TimeoutImpl other = (TimeoutImpl)obj;
        if (this.queryTimeout == null ? other.queryTimeout != null : !this.queryTimeout.equals(other.queryTimeout)) {
            return false;
        }
        if (this.setTxQueryTimeout == null ? other.setTxQueryTimeout != null : !this.setTxQueryTimeout.equals(other.setTxQueryTimeout)) {
            return false;
        }
        return !(this.useTryLock == null ? other.useTryLock != null : !this.useTryLock.equals(other.useTryLock));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<timeout>");
        if (this.blockingTimeoutMillis != null) {
            sb.append("<").append("blocking-timeout-millis").append(">");
            sb.append(this.blockingTimeoutMillis);
            sb.append("</").append("blocking-timeout-millis").append(">");
        }
        if (this.idleTimeoutMinutes != null) {
            sb.append("<").append("idle-timeout-minutes").append(">");
            sb.append(this.idleTimeoutMinutes);
            sb.append("</").append("idle-timeout-minutes").append(">");
        }
        if (this.setTxQueryTimeout != null && Boolean.TRUE.equals(this.setTxQueryTimeout)) {
            sb.append("<").append("set-tx-query-timeout").append("/>");
        }
        if (this.queryTimeout != null) {
            sb.append("<").append("query-timeout").append(">");
            sb.append(this.queryTimeout);
            sb.append("</").append("query-timeout").append(">");
        }
        if (this.useTryLock != null) {
            sb.append("<").append("use-try-lock").append(">");
            sb.append(this.useTryLock);
            sb.append("</").append("use-try-lock").append(">");
        }
        if (this.allocationRetry != null) {
            sb.append("<").append("allocation-retry").append(">");
            sb.append(this.allocationRetry);
            sb.append("</").append("allocation-retry").append(">");
        }
        if (this.allocationRetryWaitMillis != null) {
            sb.append("<").append("allocation-retry-wait-millis").append(">");
            sb.append(this.allocationRetryWaitMillis);
            sb.append("</").append("allocation-retry-wait-millis").append(">");
        }
        if (this.xaResourceTimeout != null) {
            sb.append("<").append("xa-resource-timeout").append(">");
            sb.append(this.xaResourceTimeout);
            sb.append("</").append("xa-resource-timeout").append(">");
        }
        sb.append("</timeout>");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidateException {
        if (this.queryTimeout != null && this.queryTimeout < 0L) {
            throw new ValidateException(bundle.invalidNegative("query-timeout"));
        }
        if (this.useTryLock != null && this.useTryLock < 0L) {
            throw new ValidateException(bundle.invalidNegative("use-try-lock"));
        }
    }
}

