/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Map;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.ds.Validation;
import org.ironjacamar.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class ValidationImpl
extends org.ironjacamar.common.metadata.common.ValidationImpl
implements Validation {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private Extension validConnectionChecker;
    private String checkValidConnectionSql;
    private Extension staleConnectionChecker;
    private Extension exceptionSorter;

    public ValidationImpl(Boolean backgroundValidation, Long backgroundValidationMillis, Boolean useFastFail, Extension validConnectionChecker, String checkValidConnectionSql, Boolean validateOnMatch, Extension staleConnectionChecker, Extension exceptionSorter, Map<String, String> expressions) throws ValidateException {
        super(validateOnMatch, backgroundValidation, backgroundValidationMillis, useFastFail, expressions);
        this.validConnectionChecker = validConnectionChecker;
        this.checkValidConnectionSql = checkValidConnectionSql;
        this.staleConnectionChecker = staleConnectionChecker;
        this.exceptionSorter = exceptionSorter;
        this.validate();
    }

    @Override
    public String getCheckValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    @Override
    public Extension getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    @Override
    public Extension getStaleConnectionChecker() {
        return this.staleConnectionChecker;
    }

    @Override
    public Extension getExceptionSorter() {
        return this.exceptionSorter;
    }

    @Override
    public void validate() throws ValidateException {
        if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative("background-validation-millis"));
        }
        if (this.validConnectionChecker != null) {
            try {
                this.validConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag("valid-connection-checker"), ve);
            }
        }
        if (this.exceptionSorter != null) {
            try {
                this.exceptionSorter.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag("exception-sorter"), ve);
            }
        }
        if (this.staleConnectionChecker != null) {
            try {
                this.staleConnectionChecker.validate();
            }
            catch (ValidateException ve) {
                throw new ValidateException(bundle.invalidTag("stale-connection-checker"), ve);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<validation>");
        if (this.validConnectionChecker != null) {
            sb.append("<").append("valid-connection-checker");
            sb.append(this.validConnectionChecker.toString());
            sb.append("</").append("valid-connection-checker").append(">");
        }
        if (this.checkValidConnectionSql != null) {
            sb.append("<").append("check-valid-connection-sql").append(">");
            sb.append(this.checkValidConnectionSql);
            sb.append("</").append("check-valid-connection-sql").append(">");
        }
        if (this.validateOnMatch != null) {
            sb.append("<").append("validate-on-match").append(">");
            sb.append(this.validateOnMatch);
            sb.append("</").append("validate-on-match").append(">");
        }
        if (this.backgroundValidation != null) {
            sb.append("<").append("background-validation").append(">");
            sb.append(this.backgroundValidation);
            sb.append("</").append("background-validation").append(">");
        }
        if (this.backgroundValidationMillis != null) {
            sb.append("<").append("background-validation-millis").append(">");
            sb.append(this.backgroundValidationMillis);
            sb.append("</").append("background-validation-millis").append(">");
        }
        if (this.useFastFail != null) {
            sb.append("<").append("use-fast-fail").append(">");
            sb.append(this.useFastFail);
            sb.append("</").append("use-fast-fail").append(">");
        }
        if (this.staleConnectionChecker != null) {
            sb.append("<").append("stale-connection-checker");
            sb.append(this.staleConnectionChecker.toString());
            sb.append("</").append("stale-connection-checker").append(">");
        }
        if (this.exceptionSorter != null) {
            sb.append("<").append("exception-sorter");
            sb.append(this.exceptionSorter.toString());
            sb.append("</").append("exception-sorter").append(">");
        }
        sb.append("</validation>");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkValidConnectionSql == null ? 0 : this.checkValidConnectionSql.hashCode());
        result = 31 * result + (this.exceptionSorter == null ? 0 : this.exceptionSorter.hashCode());
        result = 31 * result + (this.staleConnectionChecker == null ? 0 : this.staleConnectionChecker.hashCode());
        result = 31 * result + (this.validConnectionChecker == null ? 0 : this.validConnectionChecker.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValidationImpl)) {
            return false;
        }
        ValidationImpl other = (ValidationImpl)obj;
        if (this.checkValidConnectionSql == null ? other.checkValidConnectionSql != null : !this.checkValidConnectionSql.equals(other.checkValidConnectionSql)) {
            return false;
        }
        if (this.exceptionSorter == null ? other.exceptionSorter != null : !this.exceptionSorter.equals(other.exceptionSorter)) {
            return false;
        }
        if (this.staleConnectionChecker == null ? other.staleConnectionChecker != null : !this.staleConnectionChecker.equals(other.staleConnectionChecker)) {
            return false;
        }
        return !(this.validConnectionChecker == null ? other.validConnectionChecker != null : !this.validConnectionChecker.equals(other.validConnectionChecker));
    }
}

