/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Recovery;
import org.ironjacamar.common.api.metadata.ds.DsSecurity;
import org.ironjacamar.common.api.metadata.ds.DsXaPool;
import org.ironjacamar.common.api.metadata.ds.Statement;
import org.ironjacamar.common.api.metadata.ds.Timeout;
import org.ironjacamar.common.api.metadata.ds.TransactionIsolation;
import org.ironjacamar.common.api.metadata.ds.Validation;
import org.ironjacamar.common.api.metadata.ds.XaDataSource;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.ds.DataSourceAbstractImpl;

public class XADataSourceImpl
extends DataSourceAbstractImpl
implements XaDataSource {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, String> xaDataSourceProperty;
    protected String xaDataSourceClass;
    protected DsXaPool xaPool;
    protected Recovery recovery;
    protected String urlProperty;

    public XADataSourceImpl(TransactionIsolation transactionIsolation, Timeout timeout, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlProperty, String urlSelectorStrategyClassName, String id, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, Boolean connectable, Boolean tracking, Map<String, String> xaDataSourceProperty, String xaDataSourceClass, String driver, String newConnectionSql, DsXaPool xaPool, Recovery recovery, Map<String, String> expressions) throws ValidateException {
        super(transactionIsolation, timeout, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, id, enabled, jndiName, spy, useCcm, driver, newConnectionSql, connectable, tracking, expressions);
        if (xaDataSourceProperty != null) {
            this.xaDataSourceProperty = new HashMap(xaDataSourceProperty.size());
            this.xaDataSourceProperty.putAll(xaDataSourceProperty);
        } else {
            this.xaDataSourceProperty = new HashMap(0);
        }
        this.xaDataSourceClass = xaDataSourceClass;
        this.xaPool = xaPool;
        this.recovery = recovery;
        this.urlProperty = urlProperty;
        this.validate();
    }

    @Override
    public String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    @Override
    public Map<String, String> getXaDataSourceProperty() {
        return Collections.unmodifiableMap(this.xaDataSourceProperty);
    }

    @Override
    public DsXaPool getXaPool() {
        return this.xaPool;
    }

    @Override
    public String getUrlProperty() {
        return this.urlProperty;
    }

    @Override
    public Recovery getRecovery() {
        return this.recovery;
    }

    public void forceXaDataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    @Override
    public void validate() throws ValidateException {
        if (!(this.xaDataSourceClass != null && this.xaDataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing("xa-datasource-class", this.getClass().getCanonicalName()));
        }
        if (this.xaDataSourceProperty.isEmpty()) {
            throw new ValidateException(bundle.requiredElementMissing("xa-datasource-property", this.getClass().getCanonicalName()));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = 31 * result + (this.xaDataSourceProperty == null ? 0 : this.xaDataSourceProperty.hashCode());
        result = 31 * result + (this.xaPool == null ? 0 : this.xaPool.hashCode());
        result = 31 * result + (this.urlProperty == null ? 0 : this.urlProperty.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XADataSourceImpl)) {
            return false;
        }
        XADataSourceImpl other = (XADataSourceImpl)obj;
        if (this.xaDataSourceClass == null ? other.xaDataSourceClass != null : !this.xaDataSourceClass.equals(other.xaDataSourceClass)) {
            return false;
        }
        if (this.xaDataSourceProperty == null ? other.xaDataSourceProperty != null : !this.xaDataSourceProperty.equals(other.xaDataSourceProperty)) {
            return false;
        }
        if (this.xaPool == null ? other.xaPool != null : !this.xaPool.equals(other.xaPool)) {
            return false;
        }
        return !(this.urlProperty == null ? other.urlProperty != null : !this.urlProperty.equals(other.urlProperty));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xa-datasource");
        if (this.jndiName != null) {
            sb.append(" ").append("jndi-name").append("=\"").append(this.jndiName).append("\"");
        }
        if (this.id != null) {
            sb.append(" ").append("id").append("=\"").append(this.id).append("\"");
        }
        if (this.enabled != null && !Defaults.ENABLED.equals(this.enabled)) {
            sb.append(" ").append("enabled").append("=\"").append(this.enabled).append("\"");
        }
        if (this.spy != null && !Defaults.SPY.equals(this.spy)) {
            sb.append(" ").append("spy").append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null && !Defaults.USE_CCM.equals(this.useCcm)) {
            sb.append(" ").append("use-ccm").append("=\"").append(this.useCcm).append("\"");
        }
        if (this.connectable != null && !Defaults.CONNECTABLE.equals(this.connectable)) {
            sb.append(" ").append("connectable").append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append("tracking").append("=\"").append(this.tracking).append("\"");
        }
        sb.append(">");
        if (this.xaDataSourceProperty != null && !this.xaDataSourceProperty.isEmpty()) {
            for (Map.Entry<String, String> entry : this.xaDataSourceProperty.entrySet()) {
                sb.append("<").append("xa-datasource-property");
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append("xa-datasource-property").append(">");
            }
        }
        if (this.xaDataSourceClass != null) {
            sb.append("<").append("xa-datasource-class").append(">");
            sb.append(this.xaDataSourceClass);
            sb.append("</").append("xa-datasource-class").append(">");
        }
        if (this.driver != null) {
            sb.append("<").append("driver").append(">");
            sb.append(this.driver);
            sb.append("</").append("driver").append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append("url-delimiter").append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append("url-delimiter").append(">");
        }
        if (this.urlProperty != null) {
            sb.append("<").append("url-property").append(">");
            sb.append(this.urlProperty);
            sb.append("</").append("url-property").append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append("url-selector-strategy-class-name").append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append("url-selector-strategy-class-name").append(">");
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append("new-connection-sql").append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append("new-connection-sql").append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append("transaction-isolation").append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append("transaction-isolation").append(">");
        }
        if (this.xaPool != null) {
            sb.append(this.xaPool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeout != null) {
            sb.append(this.timeout);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</xa-datasource>");
        return sb.toString();
    }
}

