/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.common.metadata.ironjacamar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.ironjacamar.common.CommonBundle;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.resourceadapter.WorkManager;
import org.ironjacamar.common.api.validator.ValidateException;
import org.ironjacamar.common.metadata.MetadataParser;
import org.ironjacamar.common.metadata.ParserException;
import org.ironjacamar.common.metadata.common.CommonIronJacamarParser;
import org.ironjacamar.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.logging.Messages;

public class IronJacamarParser
extends CommonIronJacamarParser
implements MetadataParser<Activation> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Activation parse(XMLStreamReader reader) throws Exception {
        Activation ironJacamar = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return ironJacamar;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "ironjacamar": {
                            ironJacamar = this.parseIronJacamar(reader);
                            return ironJacamar;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void store(Activation metadata, XMLStreamWriter writer) throws Exception {
        if (metadata != null && writer != null) {
            writer.writeStartElement("ironjacamar");
            this.storeCommon(metadata, writer);
            writer.writeEndElement();
        }
    }

    private Activation parseIronJacamar(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        ArrayList<AdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        TransactionSupportEnum transactionSupport = null;
        TreeMap<String, String> configProperties = null;
        WorkManager workManager = null;
        Boolean isXA = null;
        HashMap<String, String> expressions = new HashMap<String, String>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if ("ironjacamar".equals(reader.getLocalName())) {
                        return new ActivationImpl(null, null, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext, workManager, !expressions.isEmpty() ? expressions : null);
                    }
                    switch (reader.getLocalName()) {
                        case "admin-objects": 
                        case "connection-definitions": 
                        case "bean-validation-groups": 
                        case "admin-object": 
                        case "connection-definition": 
                        case "workmanager": 
                        case "bean-validation-group": 
                        case "bootstrap-context": 
                        case "config-property": 
                        case "transaction-support": {
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "admin-objects": 
                        case "connection-definitions": 
                        case "bean-validation-groups": {
                            break block0;
                        }
                        case "admin-object": {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<AdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block0;
                        }
                        case "connection-definition": {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<ConnectionDefinition>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader, isXA));
                            break block0;
                        }
                        case "workmanager": {
                            workManager = this.parseWorkManager(reader);
                            break block0;
                        }
                        case "bean-validation-group": {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader, this.getExpressionKey("bean-validation-group", Integer.toString(beanValidationGroups.size())), expressions));
                            break block0;
                        }
                        case "bootstrap-context": {
                            bootstrapContext = this.elementAsString(reader, "bootstrap-context", expressions);
                            break block0;
                        }
                        case "config-property": {
                            String n;
                            if (configProperties == null) {
                                configProperties = new TreeMap<String, String>();
                            }
                            if ((n = this.attributeAsString(reader, "name", null)) == null || n.trim().equals("")) {
                                throw new ParserException(bundle.requiredAttributeMissing("name", reader.getLocalName()));
                            }
                            configProperties.put(n, this.elementAsString(reader, this.getExpressionKey("config-property", n), expressions));
                            break block0;
                        }
                        case "transaction-support": {
                            transactionSupport = TransactionSupportEnum.valueOf(this.elementAsString(reader, "transaction-support", expressions));
                            if (transactionSupport != TransactionSupportEnum.XATransaction) break block0;
                            isXA = Boolean.TRUE;
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

